/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Predicate;

@FunctionalInterface
public interface SerPredicate<T>
extends Predicate<T>,
Serializable {
    public static <T> Predicate<T> isEqual(Object targetRef) {
        return null == targetRef ? Objects::isNull : targetRef::equals;
    }

    @Override
    default public SerPredicate<T> and(SerPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    @Override
    default public SerPredicate<T> negate() {
        return t -> !this.test(t);
    }

    @Override
    default public SerPredicate<T> or(SerPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }
}

