/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.DebugLevel;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.OperationCall;
import cascading.operation.PlannedOperation;
import cascading.operation.PlannerLevel;
import java.beans.ConstructorProperties;
import java.io.PrintStream;

public class Debug
extends BaseOperation<Long>
implements Filter<Long>,
PlannedOperation<Long> {
    private Output output = Output.STDERR;
    private String prefix = null;
    private boolean printFields = false;
    private int printFieldsEvery = 10;
    private int printTupleEvery = 1;

    public Debug() {
    }

    @ConstructorProperties(value={"prefix"})
    public Debug(String prefix) {
        this.prefix = prefix;
    }

    @ConstructorProperties(value={"prefix", "printFields"})
    public Debug(String prefix, boolean printFields) {
        this.prefix = prefix;
        this.printFields = printFields;
    }

    @ConstructorProperties(value={"printFields"})
    public Debug(boolean printFields) {
        this.printFields = printFields;
    }

    @ConstructorProperties(value={"output"})
    public Debug(Output output) {
        this.output = output;
    }

    @ConstructorProperties(value={"output", "prefix"})
    public Debug(Output output, String prefix) {
        this.output = output;
        this.prefix = prefix;
    }

    @ConstructorProperties(value={"output", "prefix", "printFields"})
    public Debug(Output output, String prefix, boolean printFields) {
        this.output = output;
        this.prefix = prefix;
        this.printFields = printFields;
    }

    @ConstructorProperties(value={"output", "printFields"})
    public Debug(Output output, boolean printFields) {
        this.output = output;
        this.printFields = printFields;
    }

    public Output getOutput() {
        return this.output;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isPrintFields() {
        return this.printFields;
    }

    public int getPrintFieldsEvery() {
        return this.printFieldsEvery;
    }

    public void setPrintFieldsEvery(int printFieldsEvery) {
        this.printFieldsEvery = printFieldsEvery;
    }

    public int getPrintTupleEvery() {
        return this.printTupleEvery;
    }

    public void setPrintTupleEvery(int printTupleEvery) {
        this.printTupleEvery = printTupleEvery;
    }

    @Override
    public boolean supportsPlannerLevel(PlannerLevel plannerLevel) {
        return plannerLevel instanceof DebugLevel;
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Long> operationCall) {
        super.prepare(flowProcess, operationCall);
        operationCall.setContext(0L);
    }

    @Override
    public boolean isRemove(FlowProcess flowProcess, FilterCall<Long> filterCall) {
        PrintStream stream;
        PrintStream printStream = stream = this.output == Output.STDOUT ? System.out : System.err;
        if (this.printFields && (Long)filterCall.getContext() % (long)this.printFieldsEvery == 0L) {
            this.print(stream, filterCall.getArguments().getFields().print());
        }
        if ((Long)filterCall.getContext() % (long)this.printTupleEvery == 0L) {
            this.print(stream, filterCall.getArguments().getTuple().print());
        }
        filterCall.setContext((Long)filterCall.getContext() + 1L);
        return false;
    }

    @Override
    public void cleanup(FlowProcess flowProcess, OperationCall<Long> longOperationCall) {
        if (longOperationCall.getContext() == null) {
            return;
        }
        PrintStream stream = this.output == Output.STDOUT ? System.out : System.err;
        this.print(stream, "tuples count: " + longOperationCall.getContext().toString());
    }

    private void print(PrintStream stream, String message) {
        if (this.prefix != null) {
            stream.print(this.prefix);
            stream.print(": ");
        }
        stream.println(message);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Debug)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Debug debug = (Debug)object;
        if (this.printFields != debug.printFields) {
            return false;
        }
        if (this.printFieldsEvery != debug.printFieldsEvery) {
            return false;
        }
        if (this.printTupleEvery != debug.printTupleEvery) {
            return false;
        }
        if (this.output != debug.output) {
            return false;
        }
        return !(this.prefix != null ? !this.prefix.equals(debug.prefix) : debug.prefix != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
        result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
        result = 31 * result + (this.printFields ? 1 : 0);
        result = 31 * result + this.printFieldsEvery;
        result = 31 * result + this.printTupleEvery;
        return result;
    }

    public static enum Output {
        STDOUT,
        STDERR;

    }
}

