/*
 * Decompiled with CFR 0.152.
 */
package cascading.management.state;

import cascading.management.CascadingServices;
import cascading.management.DocumentService;
import cascading.management.MetricsService;
import cascading.provider.CascadingService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseState
implements CascadingService {
    private static final Logger LOG = LoggerFactory.getLogger(BaseState.class);
    private String id;
    MetricsService metricsService = new CascadingServices.NullMetricsService();
    DocumentService documentService = new CascadingServices.NullDocumentService();

    @Override
    public boolean isEnabled() {
        return this.metricsService.isEnabled() || this.documentService.isEnabled();
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
    }

    public void initialize(CascadingServices cascadingServices, String id) {
        this.id = id;
        if (cascadingServices == null) {
            return;
        }
        this.metricsService = cascadingServices.getMetricsService();
        this.documentService = cascadingServices.getDocumentService();
    }

    @Override
    public synchronized void startService() {
        if (!this.safelyStartService(this.metricsService)) {
            this.metricsService = new CascadingServices.NullMetricsService();
        }
        if (!this.safelyStartService(this.documentService)) {
            this.documentService = new CascadingServices.NullDocumentService();
        }
    }

    private boolean safelyStartService(CascadingService service) {
        try {
            service.startService();
            return true;
        }
        catch (Throwable throwable) {
            LOG.warn("unable to start cascading service: {}, with message: {}", (Object)service.getClass().getName(), (Object)throwable.getMessage());
            LOG.debug("with exception", throwable);
            return false;
        }
    }

    @Override
    public void stopService() {
    }

    String[] getContext(Enum context) {
        return this.getContext(this.getGroup(context), context.toString());
    }

    String getGroup(Enum metric) {
        return metric.getClass().getSimpleName();
    }

    abstract String[] getContext(String var1, String var2);

    public String getID() {
        return this.id;
    }

    protected void store(String id, Object value) {
        this.documentService.put(id, value);
    }

    protected void setMetric(Enum metric, long value) {
        this.metricsService.set(this.getContext(metric), value);
    }

    protected void setMetric(String group, String metric, long value) {
        this.metricsService.set(this.getContext(group, metric), value);
    }

    protected void setMetric(String group, String metric, String value) {
        this.metricsService.set(this.getContext(group, metric), value);
    }

    private void incrementMetric(Enum metric, int value) {
        this.metricsService.increment(this.getContext(metric), value);
    }

    private void incrementMetric(String group, String metric, int value) {
        this.metricsService.increment(this.getContext(group, metric), value);
    }

    String[] asArray(String ... strings) {
        return strings;
    }
}

