/*
 * Decompiled with CFR 0.152.
 */
package cascading.management.annotation;

import cascading.management.annotation.Sanitizer;
import cascading.management.annotation.Visibility;
import cascading.util.Util;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URISanitizer
implements Sanitizer {
    private static final Logger LOG = LoggerFactory.getLogger(URISanitizer.class);
    public static final String PARAMETER_FILTER_PROPERTY = "cascading.management.annotation.urisanitizer.parameternames";
    public static final String FAILURE_MODE_PASS_THROUGH = "cascading.management.annotation.urisanitizer.failurepassthrough";
    private Set<String> parametersToFilter;

    public URISanitizer() {
        String parameterProperty = System.getProperty(PARAMETER_FILTER_PROPERTY);
        if (Util.isEmpty(parameterProperty)) {
            this.parametersToFilter = Collections.emptySet();
        } else {
            String[] parameterNames;
            this.parametersToFilter = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (String parameterName : parameterNames = parameterProperty.split(",")) {
                if (parameterName != null) {
                    parameterName = parameterName.trim();
                }
                if (Util.isEmpty(parameterName)) continue;
                this.parametersToFilter.add(parameterName);
            }
        }
    }

    @Override
    public String apply(Visibility visibility, Object value) {
        URI uri;
        if (value == null) {
            return null;
        }
        if (value instanceof URI) {
            uri = (URI)value;
        } else {
            try {
                uri = URI.create(this.encode(value.toString()));
            }
            catch (IllegalArgumentException exception) {
                LOG.warn("failed to parse uri: {}, message: {}", value, (Object)exception.getMessage());
                LOG.debug("failed to parse uri: {}", value, (Object)exception);
                if (Boolean.parseBoolean(System.getProperty(FAILURE_MODE_PASS_THROUGH))) {
                    LOG.warn("ignoring uri sanitizer failures, returning unsanitized value, property '{}' set to true", (Object)FAILURE_MODE_PASS_THROUGH);
                    return value.toString();
                }
                LOG.info("set property: '{}', to true to return unsanitized value, returning empty string", (Object)FAILURE_MODE_PASS_THROUGH);
                return "";
            }
        }
        if (uri.isOpaque()) {
            switch (visibility) {
                case PRIVATE: {
                    return value.toString();
                }
                case PROTECTED: 
                case PUBLIC: {
                    return uri.getScheme() + ":";
                }
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (uri.getPath() != null) {
            buffer.append(uri.getPath());
        }
        if ((visibility == Visibility.PROTECTED || visibility == Visibility.PRIVATE) && uri.getQuery() != null) {
            buffer.append("?").append(this.sanitizeQuery(uri.getQuery()));
        }
        if (visibility == Visibility.PRIVATE) {
            String currentString = buffer.toString();
            buffer = new StringBuilder();
            if (uri.getScheme() != null) {
                buffer.append(uri.getScheme()).append("://");
            }
            if (uri.getAuthority() != null) {
                buffer.append(uri.getAuthority());
            }
            buffer.append(currentString);
        }
        return buffer.toString();
    }

    private String encode(String input) {
        String[] parts = input.split("://", 2);
        String protocol = "";
        if (parts.length == 2) {
            protocol = parts[0];
        }
        String rest = parts[parts.length - 1];
        rest = rest.replaceAll("\\[", "%5B");
        rest = rest.replaceAll("\\]", "%5D");
        rest = rest.replaceAll("\\{", "%7B");
        rest = rest.replaceAll("\\}", "%7D");
        rest = rest.replaceAll("\\\\", "/");
        rest = rest.replaceAll(";", "%3B");
        rest = rest.replaceAll(",", "%2C");
        StringBuilder builder = new StringBuilder();
        if (!protocol.isEmpty()) {
            builder.append(protocol).append("://");
        }
        builder.append(rest);
        return builder.toString();
    }

    private String sanitizeQuery(String query) {
        String[] parts;
        StringBuilder buffer = new StringBuilder();
        for (String part : parts = query.split("&")) {
            String[] keyValuePair = part.split("=");
            String key = keyValuePair[0];
            if (this.parametersToFilter.contains(key)) continue;
            buffer.append(part).append("&");
        }
        return buffer.toString();
    }
}

