/*
 * Decompiled with CFR 0.152.
 */
package cascading.management;

import cascading.management.UnitOfWork;
import cascading.management.UnitOfWorkSpawnStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class UnitOfWorkExecutorStrategy
implements UnitOfWorkSpawnStrategy {
    private ExecutorService executor;

    @Override
    public List<Future<Throwable>> start(UnitOfWork unitOfWork, int maxConcurrentThreads, Collection<Callable<Throwable>> values) throws InterruptedException {
        this.executor = Executors.newFixedThreadPool(maxConcurrentThreads);
        ArrayList<Future<Throwable>> futures = new ArrayList<Future<Throwable>>();
        for (Callable<Throwable> value : values) {
            futures.add(this.executor.submit(value));
        }
        this.executor.shutdown();
        return futures;
    }

    @Override
    public boolean isCompleted(UnitOfWork unitOfWork) {
        return this.executor == null || this.executor.isTerminated();
    }

    @Override
    public void complete(UnitOfWork unitOfWork, int duration, TimeUnit unit) throws InterruptedException {
        if (this.executor == null) {
            return;
        }
        this.executor.awaitTermination(duration, unit);
    }
}

