/*
 * Decompiled with CFR 0.152.
 */
package cascading.management;

import cascading.cascade.CascadeException;
import cascading.management.DocumentService;
import cascading.management.MetricsService;
import cascading.management.state.ClientState;
import cascading.property.PropertyUtil;
import cascading.provider.CascadingService;
import cascading.provider.ServiceLoader;
import cascading.util.ShutdownUtil;
import cascading.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CascadingServices {
    private static final Logger LOG = LoggerFactory.getLogger(CascadingServices.class);
    public static final String CASCADING_SERVICES = "cascading-service.properties";
    public static final String CASCADING_SERVICES_JAR = "cascading.management.service.jar";
    public static final String CASCADING_SERVICES_JAR_DISABLE = "cascading.management.service.jar.disable";
    public static final String DEFAULT_PROPERTIES = "cascading/management/service.properties";
    public static final String CONTAINER_ENABLED = "cascading.management.container.enabled";
    public static final String CONTAINER_EXCLUDE = "cascading.management.container.exclude";
    static Properties defaultProperties;
    static URL libraryURL;
    static String[] exclusions;
    Map<Object, Object> properties;
    MetricsService metricsService;
    DocumentService documentService;
    boolean enableContainer;

    private static URL parseLibraryURL(ClassLoader classLoader, String resource) {
        URL url = classLoader.getResource(resource);
        if (url != null) {
            try {
                String path = url.toURI().getSchemeSpecificPart();
                int endIndex = path.lastIndexOf(33);
                if (endIndex != -1) {
                    path = path.substring(0, endIndex);
                }
                if (path.endsWith(".jar")) {
                    return new URL(path);
                }
            }
            catch (Exception exception) {
                LOG.warn("unable to parse resource library: {}", (Object)url, (Object)exception);
            }
        }
        return null;
    }

    private static URL getLibraryURL() {
        String property = defaultProperties.getProperty(CASCADING_SERVICES_JAR);
        if (property == null) {
            return null;
        }
        String disableJar = defaultProperties.getProperty(CASCADING_SERVICES_JAR_DISABLE, System.getProperty(CASCADING_SERVICES_JAR_DISABLE, "false"));
        if (Boolean.valueOf(disableJar).booleanValue()) {
            LOG.info("property '{}' is set, ignoring services jar: {}", (Object)CASCADING_SERVICES_JAR_DISABLE, (Object)property);
            return null;
        }
        try {
            URI uri = URI.create(property);
            if (!uri.isAbsolute()) {
                uri = new URI("file", uri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            return uri.toURL();
        }
        catch (Exception exception) {
            LOG.warn("property: {}, has invalid URL value: {}", (Object)CASCADING_SERVICES_JAR, (Object)property);
            return null;
        }
    }

    private static Properties loadProperties(Properties properties, String resource, ClassLoader classLoader) {
        InputStream input = classLoader.getResourceAsStream(resource);
        try {
            if (input != null) {
                URL url = CascadingServices.parseLibraryURL(classLoader, resource);
                if (url != null) {
                    LOG.info("loading properties: {}, from jar: {}", (Object)resource, (Object)url);
                } else {
                    LOG.info("loading properties: {}, from CLASSPATH", (Object)resource);
                }
                properties.load(input);
            }
        }
        catch (IOException exception) {
            LOG.warn("unable to load properties from {}", (Object)resource, (Object)exception);
        }
        return properties;
    }

    private synchronized ServiceLoader getServiceUtil() {
        return ServiceLoader.getInstance(this.enableContainer ? libraryURL : null, exclusions);
    }

    public CascadingServices(Map<Object, Object> properties) {
        this.properties = PropertyUtil.createProperties(properties, defaultProperties);
        this.enableContainer = PropertyUtil.getProperty(properties, CONTAINER_ENABLED, defaultProperties.getProperty(CONTAINER_ENABLED, "false")).equalsIgnoreCase("true");
    }

    private Map<Object, Object> getProperties() {
        return this.properties;
    }

    public MetricsService getMetricsService() {
        if (this.metricsService == null) {
            this.metricsService = this.createMetricsService();
        }
        return this.metricsService;
    }

    public DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = this.createDocumentService();
        }
        return this.documentService;
    }

    public ClientState createClientState(String id) {
        ClientState clientState = (ClientState)this.getServiceUtil().loadServiceFrom(defaultProperties, this.getProperties(), "cascading3.management.state.service.classname");
        if (clientState != null) {
            clientState.initialize(this, id);
            return clientState;
        }
        return ClientState.NULL;
    }

    protected MetricsService createMetricsService() {
        MetricsService service = (MetricsService)this.getServiceUtil().loadSingletonServiceFrom(defaultProperties, this.getProperties(), "cascading.management.metrics.service.classname");
        if (service != null) {
            this.registerShutdownHook(service);
            return service;
        }
        return new NullMetricsService();
    }

    protected DocumentService createDocumentService() {
        DocumentService service = (DocumentService)this.getServiceUtil().loadSingletonServiceFrom(defaultProperties, this.getProperties(), "cascading3.management.document.service.classname");
        if (service != null) {
            this.registerShutdownHook(service);
            return service;
        }
        return new NullDocumentService();
    }

    private void registerShutdownHook(final CascadingService service) {
        if (service == null) {
            return;
        }
        ShutdownUtil.addHook(new ShutdownUtil.Hook(){

            @Override
            public ShutdownUtil.Hook.Priority priority() {
                return ShutdownUtil.Hook.Priority.SERVICE_PROVIDER;
            }

            @Override
            public void execute() {
                try {
                    service.stopService();
                }
                catch (Throwable throwable) {
                    LOG.error("failed stopping cascading service", throwable);
                    throw new CascadeException("failed stopping cascading service", throwable);
                }
            }
        });
    }

    static {
        ClassLoader classLoader = CascadingServices.class.getClassLoader();
        defaultProperties = CascadingServices.loadProperties(new Properties(), CASCADING_SERVICES, classLoader);
        libraryURL = CascadingServices.getLibraryURL();
        if (libraryURL != null) {
            classLoader = new URLClassLoader(new URL[]{libraryURL});
        }
        defaultProperties = CascadingServices.loadProperties(new Properties(defaultProperties), DEFAULT_PROPERTIES, classLoader);
        if (libraryURL == null) {
            libraryURL = CascadingServices.parseLibraryURL(classLoader, DEFAULT_PROPERTIES);
        }
        exclusions = Util.removeNulls(defaultProperties.getProperty(CONTAINER_EXCLUDE, "").split(","));
    }

    public static class NullMetricsService
    implements MetricsService {
        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void increment(String[] context, int amount) {
        }

        @Override
        public void set(String[] context, String value) {
        }

        @Override
        public void set(String[] context, int value) {
        }

        @Override
        public void set(String[] context, long value) {
        }

        @Override
        public String getString(String[] context) {
            return null;
        }

        @Override
        public int getInt(String[] context) {
            return 0;
        }

        @Override
        public long getLong(String[] context) {
            return 0L;
        }

        @Override
        public boolean compareSet(String[] context, String isValue, String toValue) {
            return true;
        }

        @Override
        public boolean compareSet(String[] context, int isValue, int toValue) {
            return true;
        }

        @Override
        public boolean compareSet(String[] context, long isValue, long toValue) {
            return true;
        }

        @Override
        public void setProperties(Map<Object, Object> properties) {
        }

        @Override
        public void startService() {
        }

        @Override
        public void stopService() {
        }
    }

    public static class NullDocumentService
    implements DocumentService {
        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void setProperties(Map<Object, Object> properties) {
        }

        @Override
        public void startService() {
        }

        @Override
        public void stopService() {
        }

        @Override
        public void put(String key, Object object) {
        }

        @Override
        public void put(String type, String key, Object object) {
        }

        @Override
        public Map get(String type, String key) {
            return null;
        }

        @Override
        public boolean supportsFind() {
            return false;
        }

        @Override
        public List<Map<String, Object>> find(String type, String[] query) {
            return null;
        }
    }
}

