/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream.graph;

import cascading.flow.stream.duct.CloseReducingDuct;
import cascading.flow.stream.duct.Collapsing;
import cascading.flow.stream.duct.Duct;
import cascading.flow.stream.duct.DuctGraph;
import cascading.flow.stream.duct.Fork;
import cascading.flow.stream.duct.Gate;
import cascading.flow.stream.duct.OpenDuct;
import cascading.flow.stream.duct.OpenReducingDuct;
import cascading.flow.stream.duct.OpenWindow;
import cascading.flow.stream.duct.OrdinalDuct;
import cascading.flow.stream.duct.Reducing;
import cascading.flow.stream.duct.Stage;
import cascading.flow.stream.duct.Window;
import cascading.util.Util;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamGraph {
    public static final String ERROR_DOT_FILE_NAME = "cascading.stream.error.dotfile";
    public static final String DOT_FILE_PATH = "cascading.stream.dotfile.path";
    private static final Logger LOG = LoggerFactory.getLogger(StreamGraph.class);
    private final Duct HEAD = new Extent("head");
    private final Duct TAIL = new Extent("tail");
    private final DuctGraph ductGraph = new DuctGraph();

    protected Object getProperty(String name) {
        return null;
    }

    Duct getHEAD() {
        return this.HEAD;
    }

    Duct getTAIL() {
        return this.TAIL;
    }

    public void addHead(Duct head) {
        this.addPath(this.getHEAD(), head);
    }

    public void addTail(Duct tail) {
        this.addPath(tail, this.getTAIL());
    }

    public void addPath(Duct lhs, Duct rhs) {
        this.addPath(lhs, 0, rhs);
    }

    public void addPath(Duct lhs, int ordinal, Duct rhs) {
        if (lhs == null && rhs == null) {
            throw new IllegalArgumentException("both lhs and rhs may not be null");
        }
        if (lhs == this.getTAIL()) {
            throw new IllegalStateException("lhs may not be a TAIL");
        }
        if (rhs == this.getHEAD()) {
            throw new IllegalStateException("rhs may not be a HEAD");
        }
        if (lhs == null) {
            lhs = this.getHEAD();
        }
        if (rhs == null) {
            rhs = this.getTAIL();
        }
        try {
            this.ductGraph.addVertex(lhs);
            this.ductGraph.addVertex(rhs);
            this.ductGraph.addEdge(lhs, rhs, this.ductGraph.makeOrdinal(ordinal));
        }
        catch (RuntimeException exception) {
            LOG.error("unable to add path", (Throwable)exception);
            this.printGraphError();
            throw exception;
        }
    }

    public void bind() {
        TopologicalOrderIterator<Duct, Integer> iterator = this.getTopologicalOrderIterator();
        while (iterator.hasNext()) {
            ((Duct)iterator.next()).bind(this);
        }
        iterator = this.getReversedTopologicalOrderIterator();
        while (iterator.hasNext()) {
            ((Duct)iterator.next()).initialize();
        }
    }

    public void prepare() {
        TopologicalOrderIterator<Duct, Integer> iterator = this.getReversedTopologicalOrderIterator();
        while (iterator.hasNext()) {
            ((Duct)iterator.next()).prepare();
        }
    }

    public void cleanup() {
        TopologicalOrderIterator<Duct, Integer> iterator = this.getTopologicalOrderIterator();
        while (iterator.hasNext()) {
            ((Duct)iterator.next()).cleanup();
        }
    }

    public Collection<Duct> getHeads() {
        return Graphs.successorListOf((Graph)this.ductGraph, (Object)this.getHEAD());
    }

    public Collection<Duct> getTails() {
        return Graphs.predecessorListOf((Graph)this.ductGraph, (Object)this.getTAIL());
    }

    public Duct[] findAllNextFor(Duct current) {
        Set outgoing = this.ductGraph.outgoingEdgesOf(current);
        LinkedList<Duct> successors = new LinkedList<Duct>();
        for (DuctGraph.Ordinal edge : outgoing) {
            Duct successor = (Duct)this.ductGraph.getEdgeTarget(edge);
            if (successor == this.getHEAD()) {
                throw new IllegalStateException("HEAD may not be next");
            }
            if (successor == this.getTAIL()) continue;
            successor = this.wrapWithOrdinal(edge, successor);
            successors.add(successor);
        }
        return successors.toArray(new Duct[successors.size()]);
    }

    public Duct[] findAllPreviousFor(Duct current) {
        LinkedList predecessors = new LinkedList(Graphs.predecessorListOf((Graph)this.ductGraph, (Object)current));
        ListIterator iterator = predecessors.listIterator();
        while (iterator.hasNext()) {
            Duct successor = (Duct)iterator.next();
            if (successor == this.getTAIL()) {
                throw new IllegalStateException("TAIL may not be successor");
            }
            if (successor != this.getHEAD()) continue;
            iterator.remove();
        }
        return predecessors.toArray(new Duct[predecessors.size()]);
    }

    public Duct createNextFor(Duct current) {
        if (current == this.getHEAD() || current == this.getTAIL()) {
            return null;
        }
        Set edges = this.ductGraph.outgoingEdgesOf(current);
        if (edges.size() == 0) {
            throw new IllegalStateException("ducts must have an outgoing edge, current: " + current);
        }
        DuctGraph.Ordinal edge = (DuctGraph.Ordinal)edges.iterator().next();
        Duct next = (Duct)this.ductGraph.getEdgeTarget(edge);
        if (current instanceof Gate) {
            if (!(current instanceof Window)) {
                if (edges.size() > 1) {
                    return this.createFork(this.findAllNextFor(current));
                }
                return this.wrapWithOrdinal(edge, next);
            }
            if (next instanceof OpenWindow) {
                return next;
            }
            if (edges.size() > 1) {
                return this.createOpenWindow(this.createFork(this.findAllNextFor(current)));
            }
            if (next instanceof Reducing) {
                return this.createOpenReducingWindow(next);
            }
            return this.createOpenWindow(this.wrapWithOrdinal(edge, next));
        }
        if (current instanceof Reducing) {
            if (next instanceof Reducing) {
                return next;
            }
            if (edges.size() > 1) {
                return this.createCloseWindow(this.createFork(this.findAllNextFor(current)));
            }
            return this.createCloseWindow(this.wrapWithOrdinal(edge, next));
        }
        if (edges.size() > 1) {
            return this.createFork(this.findAllNextFor(current));
        }
        if (next == this.getTAIL()) {
            throw new IllegalStateException("tail ducts should not bind to next");
        }
        return this.wrapWithOrdinal(edge, next);
    }

    protected Duct wrapWithOrdinal(DuctGraph.Ordinal edge, Duct next) {
        if (next instanceof Collapsing) {
            next = new OrdinalDuct(next, edge.getOrdinal());
        }
        return next;
    }

    protected Duct createCloseWindow(Duct next) {
        return new CloseReducingDuct(next);
    }

    protected Duct createOpenWindow(Duct next) {
        return new OpenDuct(next);
    }

    protected Duct createOpenReducingWindow(Duct next) {
        return new OpenReducingDuct(next);
    }

    protected Duct createFork(Duct[] allNext) {
        return new Fork(allNext);
    }

    public int ordinalBetween(Duct lhs, Duct rhs) {
        return ((DuctGraph.Ordinal)this.ductGraph.getEdge(lhs, rhs)).getOrdinal();
    }

    public TopologicalOrderIterator<Duct, Integer> getTopologicalOrderIterator() {
        try {
            return new TopologicalOrderIterator((Graph)this.ductGraph);
        }
        catch (RuntimeException exception) {
            LOG.error("failed creating topological iterator", (Throwable)exception);
            this.printGraphError();
            throw exception;
        }
    }

    public TopologicalOrderIterator<Duct, Integer> getReversedTopologicalOrderIterator() {
        try {
            return new TopologicalOrderIterator((Graph)this.getReversedGraph());
        }
        catch (RuntimeException exception) {
            LOG.error("failed creating reversed topological iterator", (Throwable)exception);
            this.printGraphError();
            throw exception;
        }
    }

    public DirectedGraph getReversedGraph() {
        DuctGraph reversedGraph = new DuctGraph();
        Graphs.addGraphReversed((Graph)reversedGraph, (Graph)this.ductGraph);
        return reversedGraph;
    }

    public Collection<Duct> getAllDucts() {
        return this.ductGraph.vertexSet();
    }

    public void printGraphError() {
        String filename = (String)this.getProperty(ERROR_DOT_FILE_NAME);
        if (filename == null) {
            return;
        }
        this.printGraph(filename);
    }

    public void printGraph(String id, String classifier, int discriminator) {
        String path = (String)this.getProperty(DOT_FILE_PATH);
        if (path == null) {
            return;
        }
        classifier = Util.cleansePathName(classifier);
        path = String.format("%s/streamgraph-%s-%s-%s.dot", path, id, classifier, discriminator);
        this.printGraph(path);
    }

    public void printGraph(String filename) {
        LOG.info("writing stream graph to {}", (Object)filename);
        Util.printGraph(filename, (Graph)this.ductGraph);
    }

    public void printBoundGraph(String id, String classifier, int discriminator) {
        String path = (String)this.getProperty(DOT_FILE_PATH);
        if (path == null) {
            return;
        }
        classifier = Util.cleansePathName(classifier);
        path = String.format("%s/streamgraph-bound-%s-%s-%s.dot", path, id, classifier, discriminator);
        this.printBoundGraph(path);
    }

    public void printBoundGraph(String filename) {
        LOG.info("writing stream bound graph to {}", (Object)filename);
        DirectedMultigraph graph = new DirectedMultigraph((EdgeFactory)new EdgeFactory<Duct, Integer>(){
            int count = 0;

            public Integer createEdge(Duct sourceVertex, Duct targetVertex) {
                return this.count++;
            }
        });
        TopologicalOrderIterator<Duct, Integer> iterator = this.getTopologicalOrderIterator();
        while (iterator.hasNext()) {
            Duct previous = (Duct)iterator.next();
            if (graph.containsVertex((Object)previous) || previous instanceof Extent) continue;
            graph.addVertex((Object)previous);
            this.addNext(graph, previous);
        }
        Util.printGraph(filename, (Graph)graph);
    }

    private void addNext(DirectedMultigraph graph, Duct previous) {
        if (previous instanceof Fork) {
            for (Duct next : ((Fork)previous).getAllNext()) {
                if (next == null || next instanceof Extent) continue;
                graph.addVertex((Object)next);
                if (graph.containsEdge((Object)previous, (Object)next)) continue;
                graph.addEdge((Object)previous, (Object)next);
                this.addNext(graph, next);
            }
        } else {
            Duct next = previous.getNext();
            if (next == null || next instanceof Extent) {
                return;
            }
            graph.addVertex((Object)next);
            if (graph.containsEdge((Object)previous, (Object)next)) {
                return;
            }
            graph.addEdge((Object)previous, (Object)next);
            this.addNext(graph, next);
        }
    }

    private class Extent
    extends Stage {
        final String name;

        private Extent(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

