/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream.graph;

import cascading.flow.FlowElement;
import cascading.flow.FlowNode;
import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.AnnotatedGraph;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.Extent;
import cascading.flow.stream.annotations.BlockingMode;
import cascading.flow.stream.duct.Duct;
import cascading.flow.stream.duct.Gate;
import cascading.flow.stream.element.AggregatorEveryStage;
import cascading.flow.stream.element.BufferEveryWindow;
import cascading.flow.stream.element.ElementDuct;
import cascading.flow.stream.element.ElementFlowProcess;
import cascading.flow.stream.element.FilterEachStage;
import cascading.flow.stream.element.FunctionEachStage;
import cascading.flow.stream.element.GroupAssertionEveryStage;
import cascading.flow.stream.element.GroupingSpliceGate;
import cascading.flow.stream.element.MemoryCoGroupGate;
import cascading.flow.stream.element.MemoryHashJoinGate;
import cascading.flow.stream.element.MergeStage;
import cascading.flow.stream.element.SinkStage;
import cascading.flow.stream.element.SourceStage;
import cascading.flow.stream.element.TrapHandler;
import cascading.flow.stream.element.ValueAssertionEachStage;
import cascading.flow.stream.graph.IORole;
import cascading.flow.stream.graph.StreamGraph;
import cascading.pipe.Boundary;
import cascading.pipe.CoGroup;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.HashJoin;
import cascading.pipe.Merge;
import cascading.pipe.Pipe;
import cascading.pipe.Splice;
import cascading.tap.Tap;
import cascading.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class NodeStreamGraph
extends StreamGraph {
    protected FlowProcess flowProcess;
    protected final FlowNode node;
    protected FlowElement streamedSource;
    protected final ElementGraph elementGraph;

    public NodeStreamGraph(FlowProcess flowProcess, FlowNode node) {
        this.flowProcess = flowProcess;
        this.node = node;
        this.elementGraph = node.getElementGraph();
    }

    public NodeStreamGraph(FlowProcess flowProcess, FlowNode node, FlowElement streamedSource) {
        this.flowProcess = flowProcess;
        this.node = node;
        this.elementGraph = streamedSource == null ? node.getElementGraph() : node.getPipelineGraphFor(streamedSource);
        this.streamedSource = streamedSource;
    }

    @Override
    protected Object getProperty(String name) {
        return this.flowProcess.getProperty(name);
    }

    protected void handleDuct(FlowElement lhsElement, Duct lhsDuct) {
        List<FlowElement> successors = this.elementGraph.successorListOf(lhsElement);
        if (successors.contains(Extent.tail)) {
            this.addTail(lhsDuct);
        } else {
            this.handleSuccessors(lhsElement, lhsDuct, successors);
        }
    }

    private void handleSuccessors(FlowElement lhsElement, Duct lhsDuct, List<FlowElement> successors) {
        for (FlowElement rhsElement : Util.createIdentitySet(successors)) {
            if (rhsElement instanceof Extent) continue;
            boolean isSink = this.elementGraph.successorListOf(rhsElement).contains(Extent.tail);
            boolean isSource = this.elementGraph.predecessorListOf(rhsElement).contains(Extent.head);
            IORole role = IORole.pass;
            if (isSource && !isSink) {
                role = IORole.source;
            } else if (!isSource && isSink) {
                role = IORole.sink;
            } else if (isSource && isSink) {
                role = IORole.both;
            }
            Duct newRhsDuct = this.createDuctFor(rhsElement, role);
            Duct rhsDuct = this.findExisting(newRhsDuct);
            Set<Scope> allEdges = this.elementGraph.getAllEdges(lhsElement, rhsElement);
            for (Scope scope : allEdges) {
                int ordinal = scope.getOrdinal();
                this.addPath(lhsDuct, ordinal, rhsDuct);
            }
            if (rhsDuct != newRhsDuct) continue;
            this.handleDuct(rhsElement, rhsDuct);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Duct createDuctFor(FlowElement element, IORole role) {
        if (element instanceof Each) {
            Each eachElement = (Each)element;
            if (eachElement.isFunction()) {
                return new FunctionEachStage(this.flowProcess, eachElement);
            }
            if (eachElement.isFilter()) {
                return new FilterEachStage(this.flowProcess, eachElement);
            }
            if (!eachElement.isValueAssertion()) throw new IllegalStateException("unknown operation: " + eachElement.getOperation().getClass().getCanonicalName());
            return new ValueAssertionEachStage(this.flowProcess, eachElement);
        }
        if (element instanceof Every) {
            Every everyElement = (Every)element;
            if (everyElement.isBuffer()) {
                return new BufferEveryWindow(this.flowProcess, everyElement);
            }
            if (everyElement.isAggregator()) {
                return new AggregatorEveryStage(this.flowProcess, everyElement);
            }
            if (!everyElement.isGroupAssertion()) throw new IllegalStateException("unknown operation: " + everyElement.getOperation().getClass().getCanonicalName());
            return new GroupAssertionEveryStage(this.flowProcess, everyElement);
        }
        if (element instanceof Boundary) {
            return this.createBoundaryStage((Boundary)element, role);
        }
        if (element instanceof Splice) {
            Splice spliceElement = (Splice)element;
            if (spliceElement.isGroupBy()) {
                return this.createGroupByGate((GroupBy)spliceElement, role);
            }
            if (spliceElement.isCoGroup()) {
                return this.createCoGroupGate((CoGroup)spliceElement, role);
            }
            if (!spliceElement.isMerge()) return this.createHashJoinGate((HashJoin)element);
            return this.createMergeStage((Merge)element, role);
        }
        if (!(element instanceof Tap)) throw new IllegalStateException("unknown element type: " + element.getClass().getName());
        return this.createSinkStage((Tap)element);
    }

    protected Duct createBoundaryStage(Boundary element, IORole role) {
        throw new UnsupportedOperationException("boundary not supported by planner");
    }

    protected SinkStage createSinkStage(Tap element) {
        return new SinkStage(this.flowProcess, element);
    }

    protected abstract Gate createCoGroupGate(CoGroup var1, IORole var2);

    protected abstract Gate createGroupByGate(GroupBy var1, IORole var2);

    protected Duct createMergeStage(Merge merge, IORole both) {
        return new MergeStage(this.flowProcess, merge);
    }

    protected Gate createHashJoinGate(HashJoin join) {
        if (join.getNumSelfJoins() != 0) {
            return this.createBlockingJoinGate(join);
        }
        if (this.hasElementAnnotation(BlockingMode.Blocked, join)) {
            return this.createBlockingJoinGate(join);
        }
        return this.createNonBlockingJoinGate(join);
    }

    private boolean hasElementAnnotation(Enum annotation, FlowElement flowElement) {
        if (!((AnnotatedGraph)((Object)this.elementGraph)).hasAnnotations()) {
            return false;
        }
        return ((AnnotatedGraph)((Object)this.elementGraph)).getAnnotations().hadKey(annotation, flowElement);
    }

    protected GroupingSpliceGate createNonBlockingJoinGate(HashJoin join) {
        return new MemoryHashJoinGate(this.flowProcess, join);
    }

    protected MemoryCoGroupGate createBlockingJoinGate(HashJoin join) {
        return new MemoryCoGroupGate(this.flowProcess, join);
    }

    protected Duct findExisting(Duct current) {
        Collection<Duct> allDucts = this.getAllDucts();
        for (Duct duct : allDucts) {
            if (!duct.equals(current)) continue;
            return duct;
        }
        return current;
    }

    protected void setTraps() {
        Collection<Duct> ducts = this.getAllDucts();
        for (Duct duct : ducts) {
            if (!(duct instanceof ElementDuct)) continue;
            ElementDuct elementDuct = (ElementDuct)((Object)duct);
            FlowElement flowElement = elementDuct.getFlowElement();
            TreeSet<String> branchNames = new TreeSet<String>();
            if (flowElement instanceof Pipe) {
                branchNames.add(((Pipe)flowElement).getName());
            } else if (flowElement instanceof Tap) {
                branchNames.addAll(this.getTapBranchNamesFor(duct));
            } else {
                throw new IllegalStateException("unexpected duct type" + duct.getClass().getCanonicalName());
            }
            elementDuct.setBranchNames(branchNames);
            for (String branchName : branchNames) {
                Tap trap = this.node.getTrap(branchName);
                if (trap == null) continue;
                ElementFlowProcess elementFlowProcess = new ElementFlowProcess(this.flowProcess, trap.getConfigDef());
                elementDuct.setTrapHandler(new TrapHandler(elementFlowProcess, flowElement, trap, branchName));
                break;
            }
            if (elementDuct.hasTrapHandler()) continue;
            elementDuct.setTrapHandler(new TrapHandler(this.flowProcess));
        }
    }

    private Set<String> getTapBranchNamesFor(Duct duct) {
        if (((Tap)((ElementDuct)((Object)duct)).getFlowElement()).isTemporary()) {
            return Collections.emptySet();
        }
        if (duct instanceof SourceStage) {
            return this.node.getSourceTapNames((Tap)((SourceStage)duct).getFlowElement());
        }
        if (duct instanceof SinkStage) {
            return this.node.getSinkTapNames((Tap)((SinkStage)duct).getFlowElement());
        }
        throw new IllegalStateException("duct does not wrap a Tap: " + duct.getClass().getCanonicalName());
    }

    protected void setScopes() {
        Collection<Duct> ducts = this.getAllDucts();
        for (Duct duct : ducts) {
            if (!(duct instanceof ElementDuct)) continue;
            ElementDuct elementDuct = (ElementDuct)((Object)duct);
            elementDuct.getIncomingScopes().addAll(this.node.getPreviousScopes(elementDuct.getFlowElement()));
            elementDuct.getOutgoingScopes().addAll(this.node.getNextScopes(elementDuct.getFlowElement()));
        }
    }
}

