/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream.element;

import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.StepCounters;
import cascading.flow.stream.StopDataNotificationException;
import cascading.flow.stream.TrapException;
import cascading.flow.stream.duct.DuctException;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.util.TraceUtil;
import cascading.util.Traceable;
import cascading.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TrapHandler.class);
    final FlowProcess flowProcess;
    final FlowElement flowElement;
    final String elementTrace;
    final Tap trap;
    final String trapName;
    boolean recordElementTrace = false;
    boolean recordThrowableMessage = false;
    boolean recordThrowableStackTrace = false;
    boolean logThrowableStackTrace = true;
    boolean stackTraceTrimLine = true;
    String stackTraceLineDelimiter = "|";
    boolean recordAnyDiagnostics;
    Fields diagnosticFields = Fields.UNKNOWN;
    TupleEntry diagnosticEntry;

    public TrapHandler(FlowProcess flowProcess) {
        this.flowProcess = flowProcess;
        this.flowElement = null;
        this.trap = null;
        this.trapName = null;
        this.elementTrace = null;
    }

    public TrapHandler(FlowProcess flowProcess, FlowElement flowElement, Tap trap, String trapName) {
        this.flowProcess = flowProcess;
        this.flowElement = flowElement;
        this.trap = trap;
        this.trapName = trapName;
        this.elementTrace = flowElement instanceof Traceable ? ((Traceable)((Object)flowElement)).getTrace() : null;
        this.recordElementTrace = flowProcess.getBooleanProperty("cascading.trap.elementtrace.record", this.recordElementTrace);
        this.recordThrowableMessage = flowProcess.getBooleanProperty("cascading.trap.throwable.message.record", this.recordThrowableMessage);
        this.recordThrowableStackTrace = flowProcess.getBooleanProperty("cascading.trap.throwable.stacktrace.record", this.recordThrowableStackTrace);
        this.logThrowableStackTrace = flowProcess.getBooleanProperty("cascading.trap.throwable.stacktrace.log", this.logThrowableStackTrace);
        this.stackTraceLineDelimiter = flowProcess.getStringProperty("cascading.trap.throwable.stacktrace.line.delimiter", this.stackTraceLineDelimiter);
        this.stackTraceTrimLine = flowProcess.getBooleanProperty("cascading.trap.throwable.stacktrace.line.trim", this.stackTraceTrimLine);
        this.recordAnyDiagnostics = this.recordElementTrace || this.recordThrowableMessage || this.recordThrowableStackTrace;
        Fields fields = new Fields();
        if (this.recordElementTrace) {
            fields = fields.append(new Fields(new Comparable[]{"element-trace"}));
        }
        if (this.recordThrowableMessage) {
            fields = fields.append(new Fields(new Comparable[]{"throwable-message"}));
        }
        if (this.recordThrowableStackTrace) {
            fields = fields.append(new Fields(new Comparable[]{"throwable-stacktrace"}));
        }
        if (fields.size() != 0) {
            this.diagnosticFields = fields;
        }
        this.diagnosticEntry = new TupleEntry(this.diagnosticFields);
    }

    protected void handleReThrowableException(String message, Throwable throwable) {
        LOG.error(message, throwable);
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new DuctException(message, throwable);
    }

    protected void handleException(Throwable exception, TupleEntry tupleEntry) {
        this.handleException(this.trapName, this.trap, exception, tupleEntry);
    }

    protected void handleException(String trapName, Tap trap, Throwable throwable, TupleEntry tupleEntry) {
        TupleEntry payload;
        if (throwable instanceof StopDataNotificationException) {
            throw (StopDataNotificationException)throwable;
        }
        Throwable cause = throwable.getCause();
        if (cause instanceof OutOfMemoryError) {
            this.handleReThrowableException("caught OutOfMemoryException, will not trap, rethrowing", cause);
        }
        if (cause instanceof TrapException) {
            this.handleReThrowableException("unable to write trap data, will not trap, rethrowing", cause);
        }
        if (trap == null) {
            this.handleReThrowableException("caught Throwable, no trap available, rethrowing", throwable);
        }
        TupleEntryCollector trapCollector = this.flowProcess.getTrapCollectorFor(trap);
        if (cause instanceof TapException && ((TapException)cause).getPayload() != null) {
            payload = new TupleEntry(Fields.UNKNOWN, ((TapException)cause).getPayload());
        } else if (tupleEntry != null) {
            payload = tupleEntry;
        } else {
            LOG.error("failure resolving tuple entry", throwable);
            throw new DuctException("failure resolving tuple entry", throwable);
        }
        TupleEntry diagnostics = this.getDiagnostics(throwable);
        if (diagnostics != TupleEntry.NULL) {
            payload = diagnostics.appendNew(payload);
        }
        try {
            trapCollector.add(payload);
        }
        catch (Throwable current) {
            throw new TrapException("could not write to trap: " + trap.getIdentifier(), current);
        }
        this.flowProcess.increment(StepCounters.Tuples_Trapped, 1L);
        if (this.logThrowableStackTrace) {
            LOG.warn("exception trap on branch: '" + trapName + "', for " + Util.truncate(this.print(tupleEntry), 75), throwable);
        }
    }

    private TupleEntry getDiagnostics(Throwable throwable) {
        if (!this.recordAnyDiagnostics) {
            return TupleEntry.NULL;
        }
        Tuple diagnostics = new Tuple();
        if (this.recordElementTrace) {
            diagnostics.add((Comparable)((Object)this.elementTrace));
        }
        if (this.recordThrowableMessage) {
            diagnostics.add((Comparable)((Object)throwable.getMessage()));
        }
        if (this.recordThrowableStackTrace) {
            diagnostics.add((Comparable)((Object)TraceUtil.stringifyStackTrace(throwable, this.stackTraceLineDelimiter, this.stackTraceTrimLine, -1)));
        }
        this.diagnosticEntry.setTuple(diagnostics);
        return this.diagnosticEntry;
    }

    private String print(TupleEntry tupleEntry) {
        if (tupleEntry == null || tupleEntry.getFields() == null) {
            return "[uninitialized]";
        }
        if (tupleEntry.getTuple() == null) {
            return "fields: " + tupleEntry.getFields().printVerbose();
        }
        return "fields: " + tupleEntry.getFields().printVerbose() + " tuple: " + tupleEntry.getTuple().print();
    }
}

