/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream.element;

import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.flow.stream.duct.Collapsing;
import cascading.flow.stream.duct.Gate;
import cascading.flow.stream.element.ElementDuct;
import cascading.flow.stream.element.ElementFlowProcess;
import cascading.flow.stream.element.TrapHandler;
import cascading.flow.stream.graph.IORole;
import cascading.pipe.Pipe;
import cascading.pipe.Splice;
import cascading.tuple.TupleEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class SpliceGate<Incoming, Outgoing>
extends Gate<Incoming, Outgoing>
implements ElementDuct,
Collapsing {
    protected Splice splice;
    protected final FlowProcess flowProcess;
    protected IORole role = IORole.both;
    protected final List<Scope> incomingScopes = new ArrayList<Scope>();
    protected final List<Scope> outgoingScopes = new ArrayList<Scope>();
    private TrapHandler trapHandler;
    private Set<String> branchNames;

    public SpliceGate(FlowProcess flowProcess, Splice splice) {
        this.splice = splice;
        for (Pipe element = splice; element != null; element = element.getParent()) {
            if (!element.hasConfigDef()) continue;
            flowProcess = new ElementFlowProcess(flowProcess, element.getConfigDef());
        }
        this.flowProcess = flowProcess;
    }

    public SpliceGate(FlowProcess flowProcess, Splice splice, IORole role) {
        this.splice = splice;
        this.flowProcess = flowProcess;
        this.role = role;
    }

    public Splice getSplice() {
        return this.splice;
    }

    protected void handleReThrowableException(String message, Throwable throwable) {
        this.trapHandler.handleReThrowableException(message, throwable);
    }

    protected void handleException(Throwable exception, TupleEntry tupleEntry) {
        this.trapHandler.handleException(exception, tupleEntry);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.incomingScopes.size() == 0) {
            throw new IllegalStateException("incoming scopes may not be empty");
        }
        if (this.outgoingScopes.size() == 0) {
            throw new IllegalStateException("outgoing scope may not be empty");
        }
    }

    @Override
    public void setBranchNames(Set<String> branchNames) {
        this.branchNames = branchNames;
    }

    @Override
    public Set<String> getBranchNames() {
        return this.branchNames;
    }

    @Override
    public void setTrapHandler(TrapHandler trapHandler) {
        this.trapHandler = trapHandler;
    }

    @Override
    public boolean hasTrapHandler() {
        return this.trapHandler != null;
    }

    @Override
    public FlowElement getFlowElement() {
        return this.splice;
    }

    @Override
    public List<Scope> getOutgoingScopes() {
        return this.outgoingScopes;
    }

    @Override
    public List<Scope> getIncomingScopes() {
        return this.incomingScopes;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SpliceGate)) {
            return false;
        }
        SpliceGate that = (SpliceGate)object;
        return !(this.splice != null ? this.splice != that.splice : that.splice != null);
    }

    public final int hashCode() {
        return this.splice != null ? System.identityHashCode(this.splice) : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("{");
        sb.append("splice=").append(this.splice);
        sb.append(", role=").append((Object)this.role);
        sb.append('}');
        return sb.toString();
    }
}

