/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream.element;

import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.stream.duct.Collapsing;
import cascading.flow.stream.duct.Duct;
import cascading.flow.stream.element.ElementStage;
import cascading.flow.stream.graph.StreamGraph;
import cascading.tuple.TupleEntry;
import java.util.concurrent.atomic.AtomicInteger;

public class MergeStage
extends ElementStage<TupleEntry, TupleEntry>
implements Collapsing {
    private boolean started = false;
    protected final AtomicInteger completeCount = new AtomicInteger(0);
    private int numIncomingPaths;

    public MergeStage(FlowProcess flowProcess, FlowElement flowElement) {
        super(flowProcess, flowElement);
    }

    @Override
    public void bind(StreamGraph streamGraph) {
        super.bind(streamGraph);
        this.numIncomingPaths = streamGraph.findAllPreviousFor(this).length;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.completeCount.set(this.numIncomingPaths);
    }

    @Override
    public synchronized void start(Duct previous) {
        if (this.started) {
            return;
        }
        super.start(previous);
        this.started = true;
    }

    @Override
    public void complete(Duct previous) {
        if (this.completeCount.decrementAndGet() != 0) {
            return;
        }
        super.complete(previous);
        this.completeCount.set(this.numIncomingPaths);
    }
}

