/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream.element;

import cascading.flow.FlowProcess;
import cascading.flow.stream.element.GroupingSpliceGate;
import cascading.flow.stream.element.MemoryCoGroupClosure;
import cascading.flow.stream.graph.StreamGraph;
import cascading.pipe.Splice;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.util.TupleBuilder;
import cascading.tuple.util.TupleViews;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MemorySpliceGate
extends GroupingSpliceGate {
    protected Set<Tuple> keys;
    protected Map<Tuple, Collection<Tuple>>[] keyValues;
    protected MemoryCoGroupClosure closure;
    protected int numIncomingEventingPaths;
    protected final AtomicInteger count = new AtomicInteger(0);

    public MemorySpliceGate(FlowProcess flowProcess, Splice splice) {
        super(flowProcess, splice);
    }

    @Override
    public void bind(StreamGraph streamGraph) {
        super.bind(streamGraph);
        this.numIncomingEventingPaths = streamGraph.findAllPreviousFor(this).length;
    }

    @Override
    protected TupleBuilder createDefaultNarrowBuilder(final Fields incomingFields, final Fields narrowFields) {
        return new TupleBuilder(){
            int[] pos;
            {
                this.pos = incomingFields.getPos(narrowFields);
            }

            @Override
            public Tuple makeResult(Tuple input, Tuple output) {
                return TupleViews.createNarrow(this.pos, input);
            }
        };
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initComparators();
        this.keys = this.createKeySet();
        this.count.set(this.numIncomingEventingPaths);
    }

    @Override
    public void prepare() {
        super.prepare();
        this.keyValues = this.createKeyValuesArray();
        this.closure = new MemoryCoGroupClosure(this.flowProcess, this.splice.getNumSelfJoins(), this.keyFields, this.valuesFields);
        if (this.grouping != null && this.splice.getJoinDeclaredFields() != null && this.splice.getJoinDeclaredFields().isNone()) {
            this.grouping.joinerClosure = this.closure;
        }
    }

    protected Set<Tuple> createKeySet() {
        return Collections.synchronizedSet(new TreeSet(this.getKeyComparator()));
    }

    protected Map<Tuple, Collection<Tuple>>[] createKeyValuesArray() {
        int start;
        Map[] valueMap = new Map[this.getNumDeclaredIncomingBranches()];
        for (int i = start = this.isBlockingStreamed() ? 0 : 1; i < this.getNumDeclaredIncomingBranches(); ++i) {
            valueMap[i] = this.createTupleMap();
        }
        return valueMap;
    }

    protected Map<Tuple, Collection<Tuple>> createTupleMap() {
        return new HashMap<Tuple, Collection<Tuple>>(){

            @Override
            public Collection<Tuple> get(Object object) {
                ArrayList value = (ArrayList)super.get(object);
                if (value == null) {
                    value = new ArrayList();
                    super.put((Tuple)object, value);
                }
                return value;
            }
        };
    }

    protected abstract boolean isBlockingStreamed();
}

