/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream.element;

import cascading.flow.FlowProcess;
import cascading.flow.stream.StopDataNotificationException;
import cascading.flow.stream.duct.Duct;
import cascading.flow.stream.element.MemorySpliceGate;
import cascading.pipe.Splice;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.Tuples;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryCoGroupGate
extends MemorySpliceGate {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryCoGroupGate.class);

    public MemoryCoGroupGate(FlowProcess flowProcess, Splice splice) {
        super(flowProcess, splice);
    }

    @Override
    protected boolean isBlockingStreamed() {
        return true;
    }

    @Override
    public void start(Duct previous) {
    }

    @Override
    public void receive(Duct previous, int ordinal, TupleEntry incomingEntry) {
        Tuple valuesTuple = incomingEntry.getTupleCopy();
        Tuple groupTuple = this.keyBuilder[ordinal].makeResult(valuesTuple, null);
        groupTuple = this.getDelegatedTuple(groupTuple);
        this.keys.add(groupTuple);
        ((Collection)this.keyValues[ordinal].get(groupTuple)).add(valuesTuple);
    }

    @Override
    public void complete(Duct previous) {
        if (this.count.decrementAndGet() != 0) {
            return;
        }
        this.next.start(this);
        Collection[] collections = new Collection[this.keyValues.length];
        Iterator keyIterator = this.keys.iterator();
        HashSet<Tuple> seenNulls = new HashSet<Tuple>();
        block4: while (keyIterator.hasNext()) {
            int i;
            Tuple keysTuple = (Tuple)keyIterator.next();
            keyIterator.remove();
            if (this.nullsAreNotEqual && Tuples.frequency(keysTuple, null) != 0) {
                if (seenNulls.contains(keysTuple)) continue;
                seenNulls.add(keysTuple);
                for (i = 0; i < this.keyValues.length; ++i) {
                    Collection values = (Collection)this.keyValues[i].remove(keysTuple);
                    if (values == null) continue;
                    for (int j = 0; j < this.keyValues.length; ++j) {
                        collections[j] = Collections.emptyList();
                    }
                    collections[i] = values;
                    try {
                        this.push(collections, keysTuple);
                        continue;
                    }
                    catch (StopDataNotificationException exception) {
                        LOG.info("received stop data notification: {}", (Object)exception.getMessage());
                        continue block4;
                    }
                }
                continue;
            }
            for (i = 0; i < this.keyValues.length; ++i) {
                collections[i] = (Collection)this.keyValues[i].remove(keysTuple);
                if (collections[i] != null) continue;
                collections[i] = Collections.emptyList();
            }
            try {
                this.push(collections, keysTuple);
            }
            catch (StopDataNotificationException exception) {
                LOG.info("received stop data notification: {}", (Object)exception.getMessage());
                break;
            }
        }
        this.keys = this.createKeySet();
        this.keyValues = this.createKeyValuesArray();
        this.count.set(this.numIncomingEventingPaths);
        this.next.complete(this);
    }

    private void push(Collection<Tuple>[] collections, Tuple keysTuple) {
        this.closure.reset(collections);
        this.keyEntry.setTuple(this.closure.getGroupTuple(keysTuple));
        this.tupleEntryIterator.reset(this.splice.getJoiner().getIterator(this.closure));
        this.next.receive(this, 0, this.grouping);
    }
}

