/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream.element;

import cascading.flow.FlowProcess;
import cascading.pipe.joiner.JoinerClosure;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.Tuples;
import cascading.tuple.util.TupleViews;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class MemoryCoGroupClosure
extends JoinerClosure {
    private Collection<Tuple>[] collections;
    private final int numSelfJoins;
    private final Tuple emptyTuple;
    private Tuple joinedTuple = new Tuple();
    private Tuple[] joinedTuplesArray;
    private TupleBuilder joinedBuilder;

    public MemoryCoGroupClosure(FlowProcess flowProcess, int numSelfJoins, Fields[] groupingFields, Fields[] valueFields) {
        super(flowProcess, groupingFields, valueFields);
        this.numSelfJoins = numSelfJoins;
        this.emptyTuple = Tuple.size(groupingFields[0].size());
        this.joinedTuplesArray = new Tuple[this.size()];
        this.joinedBuilder = this.makeJoinedBuilder(groupingFields);
    }

    @Override
    public int size() {
        return Math.max(this.joinFields.length, this.numSelfJoins + 1);
    }

    public void reset(Collection<Tuple>[] collections) {
        this.collections = collections;
    }

    @Override
    public Iterator<Tuple> getIterator(int pos) {
        if (this.numSelfJoins != 0) {
            return this.collections[0].iterator();
        }
        return this.collections[pos].iterator();
    }

    @Override
    public boolean isEmpty(int pos) {
        if (this.numSelfJoins != 0) {
            return this.collections[0].isEmpty();
        }
        return this.collections[pos].isEmpty();
    }

    @Override
    public Tuple getGroupTuple(Tuple keysTuple) {
        Tuples.asModifiable(this.joinedTuple);
        for (int i = 0; i < this.collections.length; ++i) {
            this.joinedTuplesArray[i] = this.collections[i].isEmpty() ? this.emptyTuple : keysTuple;
        }
        this.joinedTuple = this.joinedBuilder.makeResult(this.joinedTuplesArray);
        return this.joinedTuple;
    }

    private TupleBuilder makeJoinedBuilder(Fields[] joinFields) {
        Object[] fields;
        Object[] objectArray = fields = this.isSelfJoin() ? new Fields[this.size()] : joinFields;
        if (this.isSelfJoin()) {
            Arrays.fill(fields, 0, fields.length, joinFields[0]);
        }
        return new TupleBuilder((Fields[])fields){
            Tuple result;
            final /* synthetic */ Fields[] val$fields;
            {
                this.val$fields = fieldsArray;
                this.result = TupleViews.createComposite(this.val$fields);
            }

            @Override
            public Tuple makeResult(Tuple[] tuples) {
                return TupleViews.reset(this.result, tuples);
            }
        };
    }

    static interface TupleBuilder {
        public Tuple makeResult(Tuple[] var1);
    }
}

