/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream.element;

import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.flow.stream.duct.Grouping;
import cascading.flow.stream.duct.Window;
import cascading.flow.stream.element.SpliceGate;
import cascading.flow.stream.graph.IORole;
import cascading.flow.stream.util.SparseTupleComparator;
import cascading.pipe.Splice;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryChainIterator;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.Tuples;
import cascading.tuple.io.KeyTuple;
import cascading.tuple.io.TuplePair;
import cascading.tuple.io.ValueTuple;
import cascading.tuple.util.Resettable1;
import cascading.tuple.util.Resettable2;
import cascading.tuple.util.TupleBuilder;
import cascading.tuple.util.TupleHasher;
import cascading.tuple.util.TupleViews;
import cascading.util.NullSafeReverseComparator;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GroupingSpliceGate
extends SpliceGate<TupleEntry, Grouping<TupleEntry, TupleEntryIterator>>
implements Window {
    private static final Logger LOG = LoggerFactory.getLogger(GroupingSpliceGate.class);
    protected Fields[] keyFields;
    protected Fields[] sortFields;
    protected Fields[] valuesFields;
    protected Comparator<Tuple>[] groupComparators;
    protected Comparator<Tuple>[] valueComparators;
    protected TupleHasher groupHasher;
    protected boolean nullsAreNotEqual;
    protected TupleBuilder[] keyBuilder;
    protected TupleBuilder[] valuesBuilder;
    protected TupleBuilder[] sortBuilder;
    protected Tuple keyTuple;
    protected Resettable1<Tuple> groupTuple;
    protected Resettable2<Tuple, Tuple> groupSortTuple;
    protected Resettable1<Tuple> valueTuple;
    protected Grouping<TupleEntry, TupleEntryIterator> grouping;
    protected TupleEntry keyEntry;
    protected TupleEntryChainIterator tupleEntryIterator;

    protected GroupingSpliceGate(FlowProcess flowProcess, Splice splice) {
        super(flowProcess, splice);
    }

    protected GroupingSpliceGate(FlowProcess flowProcess, Splice splice, IORole role) {
        super(flowProcess, splice, role);
    }

    protected TupleBuilder createNarrowBuilder(final Fields incomingFields, final Fields narrowFields) {
        if (narrowFields.isNone()) {
            return new TupleBuilder(){

                @Override
                public Tuple makeResult(Tuple input, Tuple output) {
                    return Tuple.NULL;
                }
            };
        }
        if (incomingFields.isUnknown()) {
            return new TupleBuilder(){

                @Override
                public Tuple makeResult(Tuple input, Tuple output) {
                    return input.get(incomingFields, narrowFields);
                }
            };
        }
        if (narrowFields.isAll()) {
            return new TupleBuilder(){

                @Override
                public Tuple makeResult(Tuple input, Tuple output) {
                    return input;
                }
            };
        }
        return this.createDefaultNarrowBuilder(incomingFields, narrowFields);
    }

    protected TupleBuilder createDefaultNarrowBuilder(final Fields incomingFields, final Fields narrowFields) {
        return new TupleBuilder(){
            Tuple result;
            {
                this.result = TupleViews.createNarrow(incomingFields.getPos(narrowFields));
            }

            @Override
            public Tuple makeResult(Tuple input, Tuple output) {
                return TupleViews.reset(this.result, input);
            }
        };
    }

    protected TupleBuilder createNulledBuilder(final Fields incomingFields, final Fields keyField) {
        if (incomingFields.isUnknown()) {
            return new TupleBuilder(){

                @Override
                public Tuple makeResult(Tuple input, Tuple output) {
                    return Tuples.nulledCopy(incomingFields, input, keyField);
                }
            };
        }
        if (keyField.isNone()) {
            return new TupleBuilder(){

                @Override
                public Tuple makeResult(Tuple input, Tuple output) {
                    return input;
                }
            };
        }
        if (keyField.isAll()) {
            return new TupleBuilder(){
                Tuple nullTuple;
                {
                    this.nullTuple = Tuple.size(incomingFields.size());
                }

                @Override
                public Tuple makeResult(Tuple input, Tuple output) {
                    return this.nullTuple;
                }
            };
        }
        return new TupleBuilder(){
            Tuple nullTuple;
            Tuple result;
            {
                this.nullTuple = Tuple.size(keyField.size());
                this.result = TupleViews.createOverride(incomingFields, keyField);
            }

            @Override
            public Tuple makeResult(Tuple baseTuple, Tuple output) {
                return TupleViews.reset(this.result, baseTuple, this.nullTuple);
            }
        };
    }

    @Override
    public void initialize() {
        super.initialize();
        int size = this.getNumDeclaredIncomingBranches();
        if (this.role == IORole.source && this.splice.isGroupBy()) {
            size = 1;
        }
        this.keyFields = new Fields[size];
        this.valuesFields = new Fields[size];
        this.keyBuilder = new TupleBuilder[size];
        this.valuesBuilder = new TupleBuilder[size];
        if (this.splice.isSorted()) {
            this.sortFields = new Fields[size];
            this.sortBuilder = new TupleBuilder[size];
        }
        Scope outgoingScope = (Scope)this.outgoingScopes.get(0);
        int numScopes = Math.min(size, this.incomingScopes.size());
        for (int i = 0; i < numScopes; ++i) {
            Scope incomingScope = (Scope)this.incomingScopes.get(i);
            int ordinal = size == 1 ? 0 : incomingScope.getOrdinal();
            this.keyFields[ordinal] = outgoingScope.getKeySelectors().get(incomingScope.getName());
            this.valuesFields[ordinal] = incomingScope.getIncomingSpliceFields();
            this.keyBuilder[ordinal] = this.createNarrowBuilder(incomingScope.getIncomingSpliceFields(), this.keyFields[ordinal]);
            this.valuesBuilder[ordinal] = this.createNulledBuilder(incomingScope.getIncomingSpliceFields(), this.keyFields[ordinal]);
            if (this.sortFields != null) {
                this.sortFields[ordinal] = outgoingScope.getSortingSelectors().get(incomingScope.getName());
                this.sortBuilder[ordinal] = this.createNarrowBuilder(incomingScope.getIncomingSpliceFields(), this.sortFields[ordinal]);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("incomingScope: {}, in pos: {}", (Object)incomingScope.getName(), (Object)ordinal);
            LOG.debug("keyFields: {}", (Object)this.printSafe(this.keyFields[ordinal]));
            LOG.debug("valueFields: {}", (Object)this.printSafe(this.valuesFields[ordinal]));
            if (this.sortFields == null) continue;
            LOG.debug("sortFields: {}", (Object)this.printSafe(this.sortFields[ordinal]));
        }
        if (this.role == IORole.sink) {
            if (this.sortFields == null) {
                this.groupTuple = new KeyTuple();
            } else {
                this.groupSortTuple = new TuplePair();
            }
            this.keyTuple = (Tuple)(this.sortFields == null ? this.groupTuple : this.groupSortTuple);
            this.valueTuple = new ValueTuple();
            return;
        }
        this.keyEntry = new TupleEntry(outgoingScope.getOutGroupingFields(), true);
        this.tupleEntryIterator = new TupleEntryChainIterator(outgoingScope.getOutValuesFields());
        this.grouping = new Grouping();
        this.grouping.key = this.keyEntry;
        this.grouping.joinIterator = this.tupleEntryIterator;
    }

    protected void initComparators() {
        Comparator defaultComparator = (Comparator)this.flowProcess.newInstance((String)this.flowProcess.getProperty("cascading.flow.tuple.element.comparator"));
        Fields[] compareFields = new Fields[this.getNumDeclaredIncomingBranches()];
        this.groupComparators = new Comparator[this.getNumDeclaredIncomingBranches()];
        if (this.splice.isSorted()) {
            this.valueComparators = new Comparator[this.getNumDeclaredIncomingBranches()];
        }
        int size = this.splice.isGroupBy() ? 1 : this.getNumDeclaredIncomingBranches();
        for (int i = 0; i < size; ++i) {
            Fields groupFields;
            Scope incomingScope = (Scope)this.incomingScopes.get(i);
            int pos = this.splice.isGroupBy() ? 0 : this.splice.getPipePos().get(incomingScope.getName());
            compareFields[pos] = groupFields = this.splice.getKeySelectors().get(incomingScope.getName());
            this.groupComparators[pos] = groupFields.size() == 0 ? groupFields : new SparseTupleComparator(Fields.asDeclaration(groupFields), defaultComparator);
            Comparator<Tuple> comparator = this.groupComparators[pos] = this.splice.isSortReversed() ? NullSafeReverseComparator.reverseOrder(this.groupComparators[pos]) : this.groupComparators[pos];
            if (this.sortFields == null) continue;
            Fields sortFields = this.splice.getSortingSelectors().get(incomingScope.getName());
            this.valueComparators[pos] = new SparseTupleComparator(this.valuesFields[pos], sortFields, defaultComparator);
            if (!this.splice.isSortReversed()) continue;
            this.valueComparators[pos] = NullSafeReverseComparator.reverseOrder(this.valueComparators[pos]);
        }
        boolean bl = this.nullsAreNotEqual = !this.areNullsEqual();
        if (this.nullsAreNotEqual) {
            LOG.debug("treating null values in Tuples at not equal during grouping");
        }
        Comparator[] hashers = TupleHasher.merge(compareFields);
        this.groupHasher = defaultComparator != null || !TupleHasher.isNull(hashers) ? new TupleHasher(defaultComparator, hashers) : null;
    }

    protected Comparator getKeyComparator() {
        if (this.groupComparators.length > 0 && this.groupComparators[0] != null) {
            return this.groupComparators[0];
        }
        return new Comparator<Comparable>(){

            @Override
            public int compare(Comparable lhs, Comparable rhs) {
                return lhs.compareTo(rhs);
            }
        };
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.next == null) {
            this.flowProcess.closeTrapCollectors();
        }
    }

    private boolean areNullsEqual() {
        try {
            Tuple tupleWithNull = Tuple.size(1);
            return this.groupComparators[0].compare(tupleWithNull, tupleWithNull) == 0;
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected int getNumDeclaredIncomingBranches() {
        return this.splice.getPrevious().length;
    }

    protected final Tuple getDelegatedTuple(Tuple object) {
        if (this.groupHasher == null) {
            return object;
        }
        return new DelegatedTuple(object);
    }

    private String printSafe(Fields fields) {
        if (fields != null) {
            return fields.printVerbose();
        }
        return "";
    }

    protected class DelegatedTuple
    extends Tuple {
        public DelegatedTuple(Tuple wrapped) {
            super(Tuple.elements(wrapped));
        }

        @Override
        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        @Override
        public int compareTo(Object other) {
            return GroupingSpliceGate.this.groupComparators[0].compare(this, (Tuple)other);
        }

        @Override
        public int hashCode() {
            return GroupingSpliceGate.this.groupHasher.hashCode(this);
        }
    }
}

