/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream.element;

import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.flow.planner.ScopedElement;
import cascading.flow.stream.duct.Duct;
import cascading.flow.stream.duct.Stage;
import cascading.flow.stream.element.ElementDuct;
import cascading.flow.stream.element.ElementFlowProcess;
import cascading.flow.stream.element.TrapHandler;
import cascading.pipe.Pipe;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class ElementStage<Incoming, Outgoing>
extends Stage<Incoming, Outgoing>
implements ElementDuct {
    protected final FlowProcess flowProcess;
    protected final FlowElement flowElement;
    protected Set<String> branchNames;
    protected TrapHandler trapHandler;
    protected final List<Scope> incomingScopes = new ArrayList<Scope>();
    protected final List<Scope> outgoingScopes = new ArrayList<Scope>();

    public ElementStage(FlowProcess flowProcess, FlowElement flowElement) {
        this.flowElement = flowElement;
        FlowElement element = flowElement;
        while (element != null) {
            if (element instanceof ScopedElement && ((ScopedElement)((Object)element)).hasConfigDef()) {
                flowProcess = new ElementFlowProcess(flowProcess, ((ScopedElement)((Object)element)).getConfigDef());
            }
            if (element instanceof Pipe) {
                element = ((Pipe)element).getParent();
                continue;
            }
            element = null;
        }
        this.flowProcess = flowProcess;
    }

    @Override
    public FlowElement getFlowElement() {
        return this.flowElement;
    }

    @Override
    public List<Scope> getIncomingScopes() {
        return this.incomingScopes;
    }

    @Override
    public Set<String> getBranchNames() {
        return this.branchNames;
    }

    @Override
    public void setBranchNames(Set<String> branchNames) {
        this.branchNames = branchNames;
    }

    @Override
    public void setTrapHandler(TrapHandler trapHandler) {
        this.trapHandler = trapHandler;
    }

    @Override
    public boolean hasTrapHandler() {
        return this.trapHandler != null;
    }

    @Override
    public List<Scope> getOutgoingScopes() {
        return this.outgoingScopes;
    }

    protected Fields getOutgoingFields() {
        return ((ScopedElement)((Object)this.unwind(this.next).getFlowElement())).resolveIncomingOperationPassThroughFields(this.outgoingScopes.get(0));
    }

    private ElementDuct unwind(Duct next) {
        if (next instanceof ElementDuct) {
            return (ElementDuct)((Object)next);
        }
        return this.unwind(next.getNext());
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.next == null) {
            this.flowProcess.closeTrapCollectors();
        }
    }

    protected void handleReThrowableException(String message, Throwable throwable) {
        this.trapHandler.handleReThrowableException(message, throwable);
    }

    protected void handleException(Throwable exception, TupleEntry tupleEntry) {
        this.trapHandler.handleException(exception, tupleEntry);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ElementStage)) {
            return false;
        }
        ElementStage that = (ElementStage)object;
        return !(this.flowElement != null ? this.flowElement != that.flowElement : that.flowElement != null);
    }

    public final int hashCode() {
        return this.flowElement != null ? System.identityHashCode(this.flowElement) : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{flowElement=").append(this.flowElement);
        sb.append('}');
        return sb.toString();
    }
}

