/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream.element;

import cascading.flow.FlowProcess;
import cascading.flow.FlowProcessWrapper;
import cascading.property.ConfigDef;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class ElementFlowProcess
extends FlowProcessWrapper {
    private final ConfigDef configDef;
    private final ConfigDef.Getter getter;

    public ElementFlowProcess(FlowProcess flowProcess, ConfigDef configDef) {
        super(flowProcess);
        this.configDef = configDef;
        this.getter = new ConfigDef.Getter(){

            @Override
            public String update(String key, String value) {
                String result = this.get(key);
                if (result == null) {
                    return value;
                }
                if (result.contains(value)) {
                    return result;
                }
                return result + "," + value;
            }

            @Override
            public String get(String key) {
                Object value = ElementFlowProcess.this.getDelegate().getProperty(key);
                if (value == null) {
                    return null;
                }
                return value.toString();
            }
        };
    }

    @Override
    public Object getProperty(String key) {
        return this.configDef.apply(key, this.getter);
    }

    @Override
    public Collection<String> getPropertyKeys() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.getDelegate().getPropertyKeys());
        keys.addAll(this.configDef.getAllKeys());
        return Collections.unmodifiableSet(keys);
    }
}

