/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream.element;

import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.flow.stream.duct.Stage;
import cascading.flow.stream.element.ElementDuct;
import cascading.flow.stream.element.ElementFlowProcess;
import cascading.flow.stream.element.TrapHandler;
import cascading.flow.stream.graph.IORole;
import cascading.pipe.Boundary;
import cascading.pipe.Pipe;
import cascading.tuple.TupleEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class BoundaryStage<Incoming, Outgoing>
extends Stage<Incoming, Outgoing>
implements ElementDuct {
    protected Boundary boundary;
    protected final FlowProcess flowProcess;
    protected IORole role = IORole.both;
    protected final List<Scope> incomingScopes = new ArrayList<Scope>();
    protected final List<Scope> outgoingScopes = new ArrayList<Scope>();
    private TrapHandler trapHandler;
    private Set<String> branchNames;

    public BoundaryStage(FlowProcess flowProcess, Boundary boundary) {
        this.boundary = boundary;
        for (Pipe element = boundary; element != null; element = element.getParent()) {
            if (!element.hasConfigDef()) continue;
            flowProcess = new ElementFlowProcess(flowProcess, element.getConfigDef());
        }
        this.flowProcess = flowProcess;
    }

    public BoundaryStage(FlowProcess flowProcess, Boundary boundary, IORole role) {
        this.boundary = boundary;
        this.flowProcess = flowProcess;
        this.role = role;
    }

    public Boundary getBoundary() {
        return this.boundary;
    }

    protected void handleReThrowableException(String message, Throwable throwable) {
        this.trapHandler.handleReThrowableException(message, throwable);
    }

    protected void handleException(Throwable exception, TupleEntry tupleEntry) {
        this.trapHandler.handleException(exception, tupleEntry);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.incomingScopes.size() == 0) {
            throw new IllegalStateException("incoming scopes may not be empty");
        }
        if (this.outgoingScopes.size() == 0) {
            throw new IllegalStateException("outgoing scope may not be empty");
        }
    }

    @Override
    public void setBranchNames(Set<String> branchNames) {
        this.branchNames = branchNames;
    }

    @Override
    public Set<String> getBranchNames() {
        return this.branchNames;
    }

    @Override
    public void setTrapHandler(TrapHandler trapHandler) {
        this.trapHandler = trapHandler;
    }

    @Override
    public boolean hasTrapHandler() {
        return this.trapHandler != null;
    }

    @Override
    public FlowElement getFlowElement() {
        return this.boundary;
    }

    @Override
    public List<Scope> getOutgoingScopes() {
        return this.outgoingScopes;
    }

    @Override
    public List<Scope> getIncomingScopes() {
        return this.incomingScopes;
    }
}

