/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream.duct;

import cascading.flow.stream.duct.Duct;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.DirectedMultigraph;

public class DuctGraph
extends DirectedMultigraph<Duct, Ordinal> {
    public DuctGraph() {
        super((EdgeFactory)new DuctOrdinalEdgeFactory());
    }

    public synchronized Ordinal makeOrdinal(int ordinal) {
        return ((DuctOrdinalEdgeFactory)this.getEdgeFactory()).makeOrdinal(ordinal);
    }

    public static class Ordinal {
        int count;
        int ordinal;

        public Ordinal(int count, int ordinal) {
            this.count = count;
            this.ordinal = ordinal;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            Ordinal ordinal = (Ordinal)object;
            return this.count == ordinal.count;
        }

        public int hashCode() {
            return this.count;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Ordinal{");
            sb.append("count=").append(this.count);
            sb.append(", ordinal=").append(this.ordinal);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class DuctOrdinalEdgeFactory
    implements EdgeFactory<Duct, Ordinal> {
        int count = 0;

        private DuctOrdinalEdgeFactory() {
        }

        public Ordinal createEdge(Duct lhs, Duct rhs) {
            return this.makeOrdinal(0);
        }

        public Ordinal makeOrdinal(int ordinal) {
            return new Ordinal(this.count++, ordinal);
        }
    }
}

