/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.rule.util;

import cascading.flow.Flow;
import cascading.flow.FlowNode;
import cascading.flow.FlowStep;
import cascading.flow.Flows;
import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.graph.FlowElementGraph;
import cascading.flow.planner.iso.GraphResult;
import cascading.flow.planner.iso.assertion.Asserted;
import cascading.flow.planner.iso.subgraph.Partitions;
import cascading.flow.planner.iso.transformer.Transformed;
import cascading.flow.planner.process.FlowNodeGraph;
import cascading.flow.planner.process.FlowStepGraph;
import cascading.flow.planner.rule.PlanPhase;
import cascading.flow.planner.rule.ProcessLevel;
import cascading.flow.planner.rule.Rule;
import cascading.flow.planner.rule.RuleResult;
import cascading.property.AppProps;
import cascading.property.PropertyUtil;
import cascading.util.ProcessLogger;
import cascading.util.Util;
import cascading.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TraceWriter {
    public static final String GREEN = "0000000000000000000400000000000000000000000000000000000000000000";
    public static final String ORANGE = "0000000000000000000E00000000000000000000000000000000000000000000";
    public static final String RED = "0000000000000000000C00000000000000000000000000000000000000000000";
    private String flowName;
    private Map properties = Collections.emptyMap();
    private ProcessLogger processLogger = ProcessLogger.NULL;
    Map<ProcessLevel, Set<Rule>> counts = new EnumMap<ProcessLevel, Set<Rule>>(ProcessLevel.class);

    public TraceWriter() {
    }

    public TraceWriter(Flow flow) {
        if (flow == null) {
            return;
        }
        this.properties = flow.getConfigAsProperties();
        this.flowName = Flows.getNameOrID(flow);
        this.processLogger = (ProcessLogger)((Object)flow);
    }

    protected Path getFullTransformTracePath(String registryName) {
        Path planTransformTracePath = this.getPlanTransformTracePath();
        if (planTransformTracePath == null) {
            return null;
        }
        return planTransformTracePath.resolve(registryName);
    }

    public boolean isTransformTraceEnabled() {
        return !this.isTransformTraceDisabled();
    }

    public boolean isTransformTraceDisabled() {
        return this.getPlanTransformTracePath() == null;
    }

    public void writeTransformPlan(String registryName, PlanPhase phase, Rule rule, int[] ordinals, GraphResult graphResult) {
        if (this.isTransformTraceDisabled()) {
            return;
        }
        String ruleName = String.format("%02d-%s-%04d", new Object[]{phase.ordinal(), phase, this.addRule(rule)});
        for (int i = 1; i < ordinals.length; ++i) {
            ruleName = String.format("%s-%04d", ruleName, ordinals[i]);
        }
        ruleName = String.format("%s-%s", ruleName, graphResult.getRuleName());
        Path path = this.getFullTransformTracePath(registryName).resolve(ruleName);
        graphResult.writeDOTs(path.toString());
        this.markResult(graphResult, path);
    }

    public void writeTransformPlan(String registryName, FlowElementGraph flowElementGraph, String name) {
        if (this.isTransformTraceDisabled()) {
            return;
        }
        if (flowElementGraph == null) {
            this.processLogger.logInfo("cannot write phase assembly trace, flowElementGraph is null", new Object[0]);
            return;
        }
        Path file = this.getFullTransformTracePath(registryName).resolve(name).normalize();
        this.processLogger.logInfo("writing phase assembly trace: {}, to: {}", name, file);
        flowElementGraph.writeDOT(file.toString());
    }

    public void writeTransformPlan(String registryName, List<? extends ElementGraph> flowElementGraphs, PlanPhase phase, String subName) {
        if (this.isTransformTraceDisabled()) {
            return;
        }
        if (flowElementGraphs == null || flowElementGraphs.isEmpty()) {
            this.processLogger.logInfo("cannot write phase step trace, flowElementGraphs is empty", new Object[0]);
            return;
        }
        for (int i = 0; i < flowElementGraphs.size(); ++i) {
            ElementGraph flowElementGraph = flowElementGraphs.get(i);
            String name = String.format("%02d-%s-%s-%04d.dot", new Object[]{phase.ordinal(), phase, subName, i});
            Path file = this.getFullTransformTracePath(registryName).resolve(name).normalize();
            this.processLogger.logInfo("writing phase step trace: {}, to: {}", name, file);
            flowElementGraph.writeDOT(file.toString());
        }
    }

    public void writeTransformPlan(String registryName, Map<ElementGraph, List<? extends ElementGraph>> parentGraphsMap, Map<ElementGraph, List<? extends ElementGraph>> subGraphsMap, PlanPhase phase, String subName) {
        if (this.isTransformTraceDisabled()) {
            return;
        }
        if (parentGraphsMap == null || parentGraphsMap.isEmpty()) {
            this.processLogger.logInfo("cannot write phase node pipeline trace, parentGraphsMap is empty", new Object[0]);
            return;
        }
        int stepCount = 0;
        for (Map.Entry<ElementGraph, List<? extends ElementGraph>> entry : parentGraphsMap.entrySet()) {
            int nodeCount = 0;
            for (ElementGraph elementGraph : entry.getValue()) {
                List<? extends ElementGraph> pipelineGraphs = subGraphsMap.get(elementGraph);
                if (pipelineGraphs == null) continue;
                for (int i = 0; i < pipelineGraphs.size(); ++i) {
                    ElementGraph flowElementGraph = pipelineGraphs.get(i);
                    String name = String.format("%02d-%s-%s-%04d-%04d-%04d.dot", new Object[]{phase.ordinal(), phase, subName, stepCount, nodeCount, i});
                    Path file = this.getFullTransformTracePath(registryName).resolve(name);
                    this.processLogger.logInfo("writing phase node pipeline trace: {}, to: {}", name, file);
                    flowElementGraph.writeDOT(file.toString());
                }
                ++nodeCount;
            }
            ++stepCount;
        }
    }

    public void writeTransformPlan(String registryName, Map<ElementGraph, List<? extends ElementGraph>> subGraphsMap, PlanPhase phase, String subName) {
        if (this.isTransformTraceDisabled()) {
            return;
        }
        if (subGraphsMap == null || subGraphsMap.isEmpty()) {
            this.processLogger.logInfo("cannot write phase node trace, subGraphs is empty", new Object[0]);
            return;
        }
        int stepCount = 0;
        for (Map.Entry<ElementGraph, List<? extends ElementGraph>> entry : subGraphsMap.entrySet()) {
            List<? extends ElementGraph> flowElementGraphs = entry.getValue();
            for (int i = 0; i < flowElementGraphs.size(); ++i) {
                ElementGraph flowElementGraph = flowElementGraphs.get(i);
                String name = String.format("%02d-%s-%s-%04d-%04d.dot", new Object[]{phase.ordinal(), phase, subName, stepCount, i});
                Path file = this.getFullTransformTracePath(registryName).resolve(name);
                this.processLogger.logInfo("writing phase node trace: {}, to: {}", name, file);
                flowElementGraph.writeDOT(file.toString());
            }
            ++stepCount;
        }
    }

    protected Path getPlanTracePath() {
        return this.applyScope(PropertyUtil.getStringProperty(System.getProperties(), this.properties, "cascading.planner.plan.path"));
    }

    protected Path getPlanTransformTracePath() {
        return this.applyScope(PropertyUtil.getStringProperty(System.getProperties(), this.properties, "cascading.planner.plan.transforms.path"));
    }

    protected Path getPlanStatsPath() {
        return this.applyScope(PropertyUtil.getStringProperty(System.getProperties(), this.properties, "cascading.planner.stats.path"));
    }

    private Path applyScope(String path) {
        if (path == null) {
            return null;
        }
        return FileSystems.getDefault().getPath(path, this.flowName);
    }

    public void writeTracePlan(String registryName, String fileName, ElementGraph elementGraph) {
        Path path = this.getPlanTracePath();
        if (path == null) {
            return;
        }
        if (elementGraph == null) {
            this.processLogger.logInfo("cannot write trace element plan, elementGraph is null", new Object[0]);
            return;
        }
        if (registryName != null) {
            path = path.resolve(registryName);
        }
        Path filePath = path.resolve(String.format("%s-%s.dot", fileName, ElementGraphs.canonicalHash(elementGraph)));
        File file = filePath.toFile();
        this.processLogger.logInfo("writing trace element plan: {}", file);
        String filename = file.toString();
        elementGraph.writeDOT(filename);
    }

    public void writeTracePlan(String registryName, String fileName, FlowStepGraph stepGraph) {
        Path path = this.getPlanTracePath();
        if (path == null) {
            return;
        }
        if (stepGraph == null) {
            this.processLogger.logInfo("cannot write step plan, stepGraph is null", new Object[0]);
            return;
        }
        if (registryName != null) {
            path = path.resolve(registryName);
        }
        Path filePath = path.resolve(String.format("%s.dot", fileName));
        File file = filePath.toFile();
        this.processLogger.logInfo("writing trace step plan: {}", file);
        stepGraph.writeDOT(file.toString());
    }

    public void writeTracePlanSteps(String directoryName, FlowStepGraph stepGraph) {
        if (stepGraph == null) {
            this.processLogger.logInfo("cannot write trace step plan, stepGraph is null", new Object[0]);
            return;
        }
        Iterator iterator = stepGraph.getTopologicalIterator();
        while (iterator.hasNext()) {
            this.writePlan((FlowStep)iterator.next(), directoryName);
        }
    }

    private void writePlan(FlowStep flowStep, String directoryName) {
        Path path = this.getPlanTracePath();
        if (path == null) {
            return;
        }
        int stepOrdinal = flowStep.getOrdinal();
        Path rootPath = path.resolve(directoryName);
        ElementGraph stepSubGraph = flowStep.getElementGraph();
        String stepGraphName = String.format("%s/%04d-step-sub-graph-%s.dot", rootPath, stepOrdinal, ElementGraphs.canonicalHash(stepSubGraph));
        stepSubGraph.writeDOT(stepGraphName);
        FlowNodeGraph flowNodeGraph = flowStep.getFlowNodeGraph();
        String stepNodeElementGraphName = String.format("%s/%04d-step-node-sub-graph.dot", rootPath, stepOrdinal);
        flowNodeGraph.writeDOTNested(stepNodeElementGraphName, stepSubGraph);
        String stepNodeGraphName = String.format("%s/%04d-step-node-graph.dot", rootPath, stepOrdinal);
        flowNodeGraph.writeDOT(stepNodeGraphName);
        Iterator<FlowNode> iterator = flowNodeGraph.getOrderedTopologicalIterator();
        while (iterator.hasNext()) {
            FlowNode flowNode = iterator.next();
            ElementGraph nodeGraph = flowNode.getElementGraph();
            int nodeOrdinal = flowNode.getOrdinal();
            String nodeGraphName = String.format("%s/%04d-%04d-step-node-sub-graph-%s.dot", rootPath, stepOrdinal, nodeOrdinal, ElementGraphs.canonicalHash(nodeGraph));
            nodeGraph.writeDOT(nodeGraphName);
            List<? extends ElementGraph> pipelineGraphs = flowNode.getPipelineGraphs();
            for (int j = 0; j < pipelineGraphs.size(); ++j) {
                ElementGraph pipelineGraph = pipelineGraphs.get(j);
                String pipelineGraphName = String.format("%s/%04d-%04d-%04d-step-node-pipeline-sub-graph.dot", rootPath, stepOrdinal, nodeOrdinal, j);
                pipelineGraph.writeDOT(pipelineGraphName);
            }
        }
    }

    public void writeFinal(String fileName, RuleResult ruleResult) {
        Path path = this.getPlanTracePath();
        if (path == null) {
            return;
        }
        Path filePath = path.resolve(String.format("%s-%s.txt", fileName, ruleResult.getRegistry().getName()));
        File file = filePath.toFile();
        this.processLogger.logInfo("writing final registry: {}", file);
        try (PrintWriter writer = new PrintWriter(file);){
            writer.println("filename names winning rule registry");
        }
        catch (IOException exception) {
            this.processLogger.logError("could not write final registry", exception);
        }
    }

    public void writeStats(PlannerContext plannerContext, RuleResult ruleResult) {
        Path path = this.getPlanStatsPath();
        if (path == null) {
            return;
        }
        File file = path.resolve(String.format("planner-stats-%s-%s.txt", new Object[]{ruleResult.getRegistry().getName(), ruleResult.getResultStatus()})).toFile();
        this.processLogger.logInfo("writing planner stats to: {}", file);
        file.getParentFile().mkdirs();
        try (PrintWriter writer = new PrintWriter(file);){
            Flow flow = plannerContext.getFlow();
            Map<Object, Object> configAsProperties = flow.getConfigAsProperties();
            writer.format("cascading version: %s, build: %s\n", TraceWriter.emptyOrValue(Version.getReleaseFull()), TraceWriter.emptyOrValue(Version.getReleaseBuild()));
            writer.format("application id: %s\n", TraceWriter.emptyOrValue(AppProps.getApplicationID(configAsProperties)));
            writer.format("application name: %s\n", TraceWriter.emptyOrValue(AppProps.getApplicationName(configAsProperties)));
            writer.format("application version: %s\n", TraceWriter.emptyOrValue(AppProps.getApplicationVersion(configAsProperties)));
            writer.format("platform: %s\n", TraceWriter.emptyOrValue(flow.getPlatformInfo()));
            writer.format("frameworks: %s\n", TraceWriter.emptyOrValue(AppProps.getApplicationFrameworks(configAsProperties)));
            writer.println();
            ruleResult.writeStats(writer);
        }
        catch (IOException exception) {
            this.processLogger.logError("could not write stats", exception);
        }
    }

    private static String emptyOrValue(Object value) {
        if (value == null) {
            return "";
        }
        if (Util.isEmpty(value.toString())) {
            return "";
        }
        return value.toString();
    }

    private void markResult(GraphResult graphResult, Path path) {
        if (graphResult instanceof Transformed) {
            this.markTransformed((Transformed)graphResult, path);
        } else if (graphResult instanceof Asserted) {
            this.markAsserted((Asserted)graphResult, path);
        } else if (graphResult instanceof Partitions) {
            this.markPartitioned((Partitions)graphResult, path);
        }
    }

    private void markPartitioned(Partitions partition, Path path) {
        String color = null;
        if (partition.hasContractedMatches()) {
            color = ORANGE;
        }
        if (partition.hasSubGraphs()) {
            color = GREEN;
        }
        this.markFolder(path, color);
    }

    private void markAsserted(Asserted asserted, Path path) {
        if (asserted.getFirstAnchor() != null) {
            this.markFolder(path, RED);
        }
    }

    private void markTransformed(Transformed transformed, Path path) {
        if (transformed.getEndGraph() != null && !transformed.getBeginGraph().equals(transformed.getEndGraph())) {
            this.markFolder(path, GREEN);
        }
    }

    private void markFolder(Path path, String color) {
        if (!Util.IS_OSX) {
            return;
        }
        if (color == null) {
            return;
        }
        File file = path.toFile();
        File parentFile = file.getParentFile();
        String name = file.getName();
        String[] command = new String[]{"xattr", "-wx", "com.apple.FinderInfo", color, name};
        Util.execProcess(parentFile, command);
    }

    int addRule(Rule rule) {
        return this.addRule(rule.getRulePhase().getLevel(), rule);
    }

    int addRule(ProcessLevel level, Rule rule) {
        if (!this.counts.containsKey((Object)level)) {
            this.counts.put(level, new LinkedHashSet());
        }
        Set<Rule> rules = this.counts.get((Object)level);
        rules.add(rule);
        return rules.size() - 1;
    }
}

