/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.rule.util;

import cascading.flow.planner.graph.ElementGraph;
import cascading.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graphs;
import org.jgrapht.graph.SimpleDirectedGraph;

public class ResultTree {
    private final SimpleDirectedGraph<Delegate, Path> graph = new SimpleDirectedGraph((EdgeFactory)new PathFactory());

    public ResultTree() {
        ((PathFactory)this.graph.getEdgeFactory()).tree = this;
    }

    public void setChildren(ElementGraph parent, List<? extends ElementGraph> children) {
        Delegate parentDelegate = new Delegate(parent);
        if (!this.graph.addVertex((Object)parentDelegate)) {
            this.graph.removeAllVertices((Collection)Graphs.successorListOf(this.graph, (Object)parentDelegate));
        }
        for (ElementGraph elementGraph : children) {
            Delegate childDelegate = new Delegate(elementGraph);
            this.graph.addVertex((Object)childDelegate);
            this.graph.addEdge((Object)parentDelegate, (Object)childDelegate);
        }
    }

    public List<? extends ElementGraph> getChildren(ElementGraph parent) {
        List delegates = Graphs.successorListOf(this.graph, (Object)new Delegate(parent));
        ArrayList<ElementGraph> results = new ArrayList<ElementGraph>();
        for (Delegate delegate : delegates) {
            results.add(delegate.graph);
        }
        return results;
    }

    public Path getEdge(ElementGraph parent, ElementGraph child) {
        return (Path)this.graph.getEdge((Object)new Delegate(parent), (Object)new Delegate(child));
    }

    public Path getIncomingEdge(ElementGraph parent) {
        return (Path)Util.getFirst(this.graph.incomingEdgesOf((Object)new Delegate(parent)));
    }

    private static class PathFactory
    implements EdgeFactory<Delegate, Path> {
        ResultTree tree;

        private PathFactory() {
        }

        public Path createEdge(Delegate sourceVertex, Delegate targetVertex) {
            Set paths = this.tree.graph.incomingEdgesOf((Object)sourceVertex);
            if (paths.size() > 1) {
                throw new IllegalStateException("too many incoming edges");
            }
            Path path = (Path)Util.getFirst(paths);
            return new Path(path, this.tree.graph.outDegreeOf((Object)sourceVertex));
        }
    }

    public static class Path {
        int[] ordinals;

        public Path(Path prior, int ordinal) {
            int[] priorOrdinals = prior == null ? new int[]{} : prior.ordinals;
            this.ordinals = new int[priorOrdinals.length + 1];
            System.arraycopy(priorOrdinals, 0, this.ordinals, 0, priorOrdinals.length);
            this.ordinals[priorOrdinals.length] = ordinal;
        }

        public Path(int ... ordinals) {
            this.ordinals = ordinals;
        }

        public int[] getOrdinals() {
            return this.ordinals;
        }
    }

    public static class Delegate {
        ElementGraph graph;

        public Delegate(ElementGraph graph) {
            this.graph = graph;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            Delegate delegate = (Delegate)object;
            return this.graph == delegate.graph;
        }

        public int hashCode() {
            return System.identityHashCode(this.graph);
        }
    }
}

