/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.rule;

import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.transformer.ContractedTransformer;
import cascading.flow.planner.iso.transformer.GraphTransformer;
import cascading.flow.planner.iso.transformer.RecursiveGraphTransformer;
import cascading.flow.planner.iso.transformer.SubGraphTransformer;
import cascading.flow.planner.iso.transformer.Transformed;
import cascading.flow.planner.rule.PlanPhase;
import cascading.flow.planner.rule.Rule;
import cascading.flow.planner.rule.RuleExpression;
import cascading.flow.planner.rule.util.LogLevel;
import cascading.flow.planner.rule.util.RuleLogUtil;

public class RuleTransformer
extends GraphTransformer<ElementGraph, ElementGraph>
implements Rule {
    private final LogLevel logLevel;
    private final PlanPhase phase;
    protected final RuleExpression ruleExpression;
    protected final ContractedTransformer contractedTransformer;
    protected final SubGraphTransformer subGraphTransformer;
    protected RecursiveGraphTransformer<ElementGraph> graphTransformer;

    public RuleTransformer(PlanPhase phase, RuleExpression ruleExpression) {
        this(null, phase, ruleExpression);
    }

    public RuleTransformer(LogLevel logLevel, PlanPhase phase, RuleExpression ruleExpression) {
        this.logLevel = logLevel;
        this.phase = phase;
        this.ruleExpression = ruleExpression;
        this.contractedTransformer = ruleExpression.getContractionExpression() != null ? new ContractedTransformer(ruleExpression.getContractionExpression()) : null;
        if (ruleExpression.getContractedMatchExpression() != null) {
            if (this.contractedTransformer == null) {
                throw new IllegalArgumentException("must have contracted expression if given contracted match expression");
            }
            this.subGraphTransformer = new SubGraphTransformer(this.contractedTransformer, ruleExpression.getContractedMatchExpression());
        } else {
            this.subGraphTransformer = null;
        }
    }

    @Override
    public PlanPhase getRulePhase() {
        return this.phase;
    }

    @Override
    public String getRuleName() {
        return this.getClass().getSimpleName().replaceAll("^(.*)[]A-Z][a-z]*Rule$", "$1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transformed<ElementGraph> transform(PlannerContext plannerContext, ElementGraph rootGraph) {
        String[] logLevels = RuleLogUtil.enableLogging(this.logLevel);
        try {
            Transformed<ElementGraph> transformed = this.performTransform(plannerContext, rootGraph);
            return transformed;
        }
        finally {
            RuleLogUtil.restoreLogging(logLevels);
        }
    }

    public Transformed<ElementGraph> performTransform(PlannerContext plannerContext, ElementGraph rootGraph) {
        Transformed<ElementGraph> result = new Transformed<ElementGraph>(plannerContext, this, rootGraph);
        ElementGraph graphCopy = rootGraph.copyElementGraph();
        Transformed<ElementGraph> transformed = this.graphTransformer.transform(plannerContext, graphCopy);
        result.addChildTransform(transformed);
        if (transformed.getEndGraph() != null && !rootGraph.equals(transformed.getEndGraph())) {
            result.setEndGraph(transformed.getEndGraph());
        }
        return result;
    }

    public String toString() {
        return this.getRuleName();
    }
}

