/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.rule;

import cascading.flow.Flow;
import cascading.flow.FlowDef;
import cascading.flow.planner.FlowPlanner;
import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.PlannerException;
import cascading.flow.planner.graph.FlowElementGraph;
import cascading.flow.planner.rule.RuleExec;
import cascading.flow.planner.rule.RuleRegistry;
import cascading.flow.planner.rule.RuleRegistrySet;
import cascading.flow.planner.rule.RuleResult;
import cascading.flow.planner.rule.util.TraceWriter;
import cascading.util.ProcessLogger;
import cascading.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class RuleSetExec {
    public static final int MAX_CONCURRENT_PLANNERS = 5;
    public static final int DEFAULT_TIMEOUT = 600;
    public static final Comparator<RuleResult> DEFAULT_PLAN_COMPARATOR = new Comparator<RuleResult>(){

        @Override
        public int compare(RuleResult lhs, RuleResult rhs) {
            int c = lhs.getNumSteps() - rhs.getNumSteps();
            if (c != 0) {
                return c;
            }
            return lhs.getNumNodes() - rhs.getNumNodes();
        }

        public String toString() {
            return "default comparator: selects plan with fewest steps and fewest nodes";
        }
    };
    private TraceWriter traceWriter;
    private FlowPlanner flowPlanner;
    private Flow flow;
    private RuleRegistrySet registrySet;
    private FlowDef flowDef;
    private FlowElementGraph flowElementGraph;
    Set<Callable> running;
    List<RuleResult> success;
    List<RuleResult> unsupported;
    List<RuleResult> illegal;
    List<RuleResult> interrupted;

    public RuleSetExec(TraceWriter traceWriter, FlowPlanner flowPlanner, Flow flow, RuleRegistrySet registrySet, FlowDef flowDef, FlowElementGraph flowElementGraph) {
        this.traceWriter = traceWriter;
        this.flowPlanner = flowPlanner;
        this.flow = flow;
        this.registrySet = registrySet;
        this.flowDef = flowDef;
        this.flowElementGraph = flowElementGraph;
    }

    protected ProcessLogger getFlowLogger() {
        return (ProcessLogger)((Object)this.flow);
    }

    protected Comparator<RuleResult> getPlanComparator() {
        if (this.registrySet.getPlanComparator() != null) {
            return this.registrySet.getPlanComparator();
        }
        return DEFAULT_PLAN_COMPARATOR;
    }

    protected Comparator<RuleResult> getOrderComparator() {
        return new Comparator<RuleResult>(){

            @Override
            public int compare(RuleResult lhs, RuleResult rhs) {
                return RuleSetExec.this.registrySet.indexOf(lhs.getRegistry()) - RuleSetExec.this.registrySet.indexOf(rhs.getRegistry());
            }
        };
    }

    public RuleResult exec() {
        this.running = Collections.synchronizedSet(new HashSet());
        this.success = Collections.synchronizedList(new ArrayList());
        this.unsupported = Collections.synchronizedList(new ArrayList());
        this.illegal = Collections.synchronizedList(new ArrayList());
        this.interrupted = Collections.synchronizedList(new ArrayList());
        List<Callable<RuleResult>> callables = this.createCallables();
        this.submitCallables(callables);
        this.notifyUnsupported();
        this.notifyIllegal();
        this.notifyInterrupted();
        return this.selectSuccess();
    }

    protected RuleResult execPlannerFor(RuleRegistry ruleRegistry) {
        this.flowPlanner.configRuleRegistryDefaults(ruleRegistry);
        String registryName = ruleRegistry.getName();
        RuleExec ruleExec = new RuleExec(this.traceWriter, ruleRegistry);
        PlannerContext plannerContext = new PlannerContext(ruleRegistry, this.flowPlanner, this.flowDef, this.flow, this.traceWriter.isTransformTraceEnabled());
        RuleResult ruleResult = ruleExec.exec(plannerContext, this.flowElementGraph);
        this.getFlowLogger().logInfo("executed rule registry: {}, completed as: {}, in: {}", new Object[]{registryName, ruleResult.getResultStatus(), Util.formatDurationFromMillis(ruleResult.getDuration())});
        this.traceWriter.writeTracePlan(registryName, "completed-flow-element-graph", ruleResult.getAssemblyGraph());
        this.traceWriter.writeStats(plannerContext, ruleResult);
        Exception plannerException = ruleResult.isSuccess() ? this.flowPlanner.verifyResult(ruleResult) : ruleResult.getPlannerException();
        if (plannerException != null && plannerException instanceof PlannerException && ((PlannerException)plannerException).getElementGraph() != null) {
            this.traceWriter.writeTracePlan(registryName, "failed-source-element-graph", ((PlannerException)plannerException).getElementGraph());
        }
        if (ruleResult.isSuccess() && plannerException != null) {
            this.rethrow(plannerException);
        }
        return ruleResult;
    }

    protected Set<Future<RuleResult>> submitCallables(List<Callable<RuleResult>> callables) {
        int size = Math.min(5, callables.size());
        ExecutorService executor = Executors.newFixedThreadPool(size);
        ExecutorCompletionService<RuleResult> completionService = new ExecutorCompletionService<RuleResult>(executor);
        HashSet<Future<RuleResult>> futures = new HashSet<Future<RuleResult>>();
        RuleRegistrySet.Select select = this.registrySet.getSelect();
        long totalDuration = this.registrySet.getPlannerTimeoutSec();
        long startAll = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        for (Callable<RuleResult> callable : callables) {
            futures.add(completionService.submit(callable));
        }
        executor.shutdown();
        try {
            boolean timedOut = false;
            while (!futures.isEmpty()) {
                Future future = completionService.poll(totalDuration, TimeUnit.SECONDS);
                long l = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) - startAll;
                totalDuration -= l;
                boolean bl = timedOut = future == null;
                if (timedOut) break;
                futures.remove(future);
                boolean success = this.binResult((RuleResult)future.get());
                if (!success || select != RuleRegistrySet.Select.FIRST) continue;
                break;
            }
            if (!futures.isEmpty()) {
                if (timedOut) {
                    this.getFlowLogger().logWarn("planner cancelling long running registries past timeout period: {}, see RuleRegistrySet#setPlannerTimeoutSec() to change timeout", Util.formatDurationFromMillis(this.registrySet.getPlannerTimeoutSec() * 1000));
                } else {
                    this.getFlowLogger().logInfo("first registry completed, planner cancelling remaining running registries: {}, successful: {}", futures.size(), this.success.size());
                }
                for (Future future : futures) {
                    future.cancel(true);
                }
                for (int timeout = 0; !this.running.isEmpty() && timeout < 60; ++timeout) {
                    Util.safeSleep(500L);
                }
            }
        }
        catch (InterruptedException exception) {
            this.getFlowLogger().logError("planner thread interrupted", exception);
            this.rethrow(exception);
        }
        catch (ExecutionException exception) {
            this.rethrow(exception.getCause());
        }
        return futures;
    }

    protected List<Callable<RuleResult>> createCallables() {
        ArrayList<Callable<RuleResult>> callables = new ArrayList<Callable<RuleResult>>();
        for (RuleRegistry ruleRegistry : this.registrySet.ruleRegistries) {
            callables.add(this.createCallable(ruleRegistry));
        }
        return callables;
    }

    private RuleResult selectSuccess() {
        if (this.success.isEmpty()) {
            throw new IllegalStateException("no planner results from registry set");
        }
        for (RuleResult ruleResult : this.success) {
            this.getFlowLogger().logInfo("rule registry: {}, supports assembly with steps: {}, nodes: {}", ruleResult.getRegistry().getName(), ruleResult.getNumSteps(), ruleResult.getNumNodes());
        }
        if (this.success.size() != 1) {
            Collections.sort(this.success, this.getOrderComparator());
            Collections.sort(this.success, this.getPlanComparator());
        }
        RuleResult ruleResult = this.success.get(0);
        if (this.registrySet.getSelect() == RuleRegistrySet.Select.FIRST) {
            this.getFlowLogger().logInfo("rule registry: {}, result was selected as first successful", ruleResult.getRegistry().getName());
        } else if (this.registrySet.getSelect() == RuleRegistrySet.Select.COMPARED) {
            this.getFlowLogger().logInfo("rule registry: {}, result was selected using: '{}'", ruleResult.getRegistry().getName(), this.getPlanComparator().toString());
        }
        return ruleResult;
    }

    private void notifyUnsupported() {
        if (this.unsupported.isEmpty()) {
            return;
        }
        for (RuleResult ruleResult : this.unsupported) {
            this.getFlowLogger().logInfo("rule registry: {}, does not support assembly", ruleResult.getRegistry().getName());
        }
        if (!this.registrySet.isIgnoreFailed() || this.success.isEmpty() && this.illegal.isEmpty() && this.interrupted.isEmpty()) {
            this.rethrow(this.unsupported.get(0).getPlannerException());
        }
    }

    private void notifyIllegal() {
        if (this.illegal.isEmpty()) {
            return;
        }
        for (RuleResult ruleResult : this.illegal) {
            this.getFlowLogger().logInfo("rule registry: {}, found assembly to be malformed", ruleResult.getRegistry().getName());
        }
        if (!this.registrySet.isIgnoreFailed() || this.success.isEmpty()) {
            this.rethrow(this.illegal.get(0).getPlannerException());
        }
    }

    private void notifyInterrupted() {
        if (this.interrupted.isEmpty()) {
            return;
        }
        for (RuleResult ruleResult : this.interrupted) {
            this.getFlowLogger().logInfo("rule registry: {}, planned longer than default duration, was cancelled", ruleResult.getRegistry().getName());
        }
        if (this.interrupted.size() == this.registrySet.size()) {
            throw new PlannerException("planner registry timeout exceeded for all registries: " + Util.formatDurationFromMillis(this.registrySet.getPlannerTimeoutSec() * 1000));
        }
        if (!this.registrySet.isIgnoreFailed() || this.success.isEmpty()) {
            this.rethrow(this.interrupted.get(0).getPlannerException());
        }
    }

    protected Callable<RuleResult> createCallable(final RuleRegistry ruleRegistry) {
        return new Callable<RuleResult>(){

            @Override
            public RuleResult call() throws Exception {
                RuleSetExec.this.running.add(this);
                try {
                    RuleResult ruleResult = RuleSetExec.this.execPlannerFor(ruleRegistry);
                    return ruleResult;
                }
                finally {
                    RuleSetExec.this.running.remove(this);
                }
            }
        };
    }

    protected boolean binResult(RuleResult ruleResult) {
        switch (ruleResult.getResultStatus()) {
            case SUCCESS: {
                this.success.add(ruleResult);
                return true;
            }
            case UNSUPPORTED: {
                this.unsupported.add(ruleResult);
                break;
            }
            case ILLEGAL: {
                this.illegal.add(ruleResult);
                break;
            }
            case INTERRUPTED: {
                this.interrupted.add(ruleResult);
            }
        }
        return false;
    }

    private void rethrow(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new PlannerException(throwable);
    }
}

