/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.rule;

import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.FlowElementGraph;
import cascading.flow.planner.rule.PlanPhase;
import cascading.flow.planner.rule.ProcessLevel;
import cascading.flow.planner.rule.Rule;
import cascading.flow.planner.rule.RuleRegistry;
import cascading.flow.planner.rule.UnsupportedPlanException;
import cascading.flow.planner.rule.util.ResultTree;
import cascading.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleResult {
    public static final int THRESHOLD_SECONDS = 10;
    private static final Logger LOG = LoggerFactory.getLogger(RuleResult.class);
    private Map<ProcessLevel, Set<ElementGraph>> levelParents = new HashMap<ProcessLevel, Set<ElementGraph>>();
    private ResultTree resultTree = new ResultTree();
    private long duration = 0L;
    private Map<PlanPhase, Long> phaseDurations = new LinkedHashMap<PlanPhase, Long>();
    private Map<PlanPhase, Map<String, Long>> ruleDurations = new LinkedHashMap<PlanPhase, Map<String, Long>>();
    protected FlowElementGraph initialAssembly;
    private RuleRegistry registry;
    private Exception plannerException;

    public RuleResult() {
        for (ProcessLevel level : ProcessLevel.values()) {
            this.levelParents.put(level, new LinkedHashSet());
        }
    }

    public RuleResult(RuleRegistry registry) {
        this();
        this.registry = registry;
    }

    public RuleResult(FlowElementGraph initialAssembly) {
        this();
        this.initResult(initialAssembly);
    }

    public RuleResult(RuleRegistry registry, FlowElementGraph initialAssembly) {
        this();
        this.registry = registry;
        this.initResult(initialAssembly);
    }

    public RuleRegistry getRegistry() {
        return this.registry;
    }

    public void setPlannerException(Exception plannerException) {
        this.plannerException = plannerException;
    }

    public Exception getPlannerException() {
        return this.plannerException;
    }

    public boolean hasPlannerException() {
        return this.plannerException != null;
    }

    public boolean isSuccess() {
        return !this.hasPlannerException();
    }

    public boolean isIllegal() {
        return !this.isSuccess() && !this.isUnsupported() && !this.isInterrupted();
    }

    public boolean isUnsupported() {
        return this.getPlannerException() instanceof UnsupportedPlanException;
    }

    public boolean isInterrupted() {
        return this.getPlannerException() instanceof InterruptedException;
    }

    public ResultStatus getResultStatus() {
        if (this.isSuccess()) {
            return ResultStatus.SUCCESS;
        }
        if (this.isUnsupported()) {
            return ResultStatus.UNSUPPORTED;
        }
        if (this.isInterrupted()) {
            return ResultStatus.INTERRUPTED;
        }
        return ResultStatus.ILLEGAL;
    }

    public void initResult(FlowElementGraph initialAssembly) {
        this.initialAssembly = initialAssembly;
        this.setLevelResults(ProcessLevel.Assembly, (ElementGraph)initialAssembly, initialAssembly.copyElementGraph());
    }

    public void setLevelResults(ProcessLevel level, Map<ElementGraph, List<? extends ElementGraph>> results) {
        for (Map.Entry<ElementGraph, List<? extends ElementGraph>> entry : results.entrySet()) {
            this.setLevelResults(level, entry.getKey(), entry.getValue());
        }
    }

    public void setLevelResults(ProcessLevel level, ElementGraph parent, ElementGraph child) {
        this.setLevelResults(level, parent, Collections.singletonList(child));
    }

    public void setLevelResults(ProcessLevel level, ElementGraph parent, List<? extends ElementGraph> elementGraphs) {
        this.levelParents.get((Object)level).add(parent);
        this.resultTree.setChildren(parent, elementGraphs);
    }

    public Map<ElementGraph, List<? extends ElementGraph>> getLevelResults(ProcessLevel level) {
        HashMap<ElementGraph, List<? extends ElementGraph>> result = new HashMap<ElementGraph, List<? extends ElementGraph>>();
        Set<ElementGraph> parents = this.levelParents.get((Object)level);
        if (!parents.isEmpty()) {
            for (ElementGraph parent : parents) {
                result.put(parent, this.resultTree.getChildren(parent));
            }
            return result;
        }
        Set<ElementGraph> top = this.levelParents.get((Object)ProcessLevel.parent(level));
        for (ElementGraph parent : top) {
            List<? extends ElementGraph> children = this.resultTree.getChildren(parent);
            for (ElementGraph elementGraph : children) {
                result.put(elementGraph, new ArrayList());
            }
        }
        return result;
    }

    public int[] getPathFor(ElementGraph parent, ElementGraph child) {
        return this.resultTree.getEdge(parent, child).getOrdinals();
    }

    public int[] getPathFor(ElementGraph parent) {
        ResultTree.Path incomingEdge = this.resultTree.getIncomingEdge(parent);
        if (incomingEdge == null) {
            return new int[0];
        }
        return incomingEdge.getOrdinals();
    }

    public FlowElementGraph getInitialAssembly() {
        return this.initialAssembly;
    }

    public FlowElementGraph getAssemblyGraph() {
        Map<ElementGraph, List<? extends ElementGraph>> results = this.getLevelResults(ProcessLevel.Assembly);
        return (FlowElementGraph)Util.getFirst((Collection)results.get(this.getInitialAssembly()));
    }

    public Map<ElementGraph, List<? extends ElementGraph>> getAssemblyToStepGraphMap() {
        return this.getLevelResults(ProcessLevel.Step);
    }

    public Map<ElementGraph, List<? extends ElementGraph>> getStepToNodeGraphMap() {
        return this.getLevelResults(ProcessLevel.Node);
    }

    public Map<ElementGraph, List<? extends ElementGraph>> getNodeToPipelineGraphMap() {
        return this.getLevelResults(ProcessLevel.Pipeline);
    }

    public int getNumSteps() {
        return this.getStepToNodeGraphMap().size();
    }

    public int getNumNodes() {
        int nodes = 0;
        for (List<? extends ElementGraph> nodesList : this.getStepToNodeGraphMap().values()) {
            nodes += nodesList.size();
        }
        return nodes;
    }

    public void setDuration(long begin, long end) {
        this.duration = end - begin;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setPhaseDuration(PlanPhase phase, long begin, long end) {
        this.phaseDurations.put(phase, end - begin);
    }

    public void setRuleDuration(Rule rule, long begin, long end) {
        Map<String, Long> durations = this.ruleDurations.get((Object)rule.getRulePhase());
        if (durations == null) {
            durations = new LinkedHashMap<String, Long>();
            this.ruleDurations.put(rule.getRulePhase(), durations);
        }
        if (durations.containsKey(rule.getRuleName())) {
            throw new IllegalStateException("duplicate rule found: " + rule.getRuleName());
        }
        long duration = end - begin;
        if (duration > 10000L) {
            LOG.info("rule: {}, took longer than {} seconds: {}", new Object[]{rule.getRuleName(), 10, Util.formatDurationFromMillis(duration)});
        }
        durations.put(rule.getRuleName(), duration);
    }

    public void writeStats(PrintWriter writer) {
        writer.format("duration\t%.03f\n", Float.valueOf((float)this.duration / 1000.0f));
        writer.println();
        for (PlanPhase phase : this.phaseDurations.keySet()) {
            long phaseDuration = this.phaseDurations.get((Object)phase);
            writer.format("%s\t%.03f\n", new Object[]{phase, Float.valueOf((float)phaseDuration / 1000.0f)});
            Map<String, Long> rules = this.ruleDurations.get((Object)phase);
            writer.println("=======================");
            if (rules != null) {
                for (String ruleName : rules.keySet()) {
                    long ruleDuration = rules.get(ruleName);
                    writer.format("%s\t%.03f\n", ruleName, Float.valueOf((float)ruleDuration / 1000.0f));
                }
            }
            writer.println("");
        }
    }

    public static enum ResultStatus {
        SUCCESS,
        UNSUPPORTED,
        ILLEGAL,
        INTERRUPTED;

    }
}

