/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.rule;

import cascading.flow.planner.rule.RuleRegistry;
import cascading.flow.planner.rule.RuleResult;
import cascading.flow.planner.rule.RuleSetExec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

public class RuleRegistrySet {
    int plannerTimeoutSec = 600;
    boolean ignoreFailed = true;
    Select select = Select.COMPARED;
    Comparator<RuleResult> planComparator = RuleSetExec.DEFAULT_PLAN_COMPARATOR;
    LinkedList<RuleRegistry> ruleRegistries = new LinkedList();

    public RuleRegistrySet(RuleRegistry ... ruleRegistries) {
        this(Arrays.asList(ruleRegistries));
    }

    public RuleRegistrySet(Collection<RuleRegistry> ruleRegistries) {
        this.ruleRegistries.addAll(ruleRegistries);
        for (RuleRegistry ruleRegistry : ruleRegistries) {
            if (Collections.frequency(this.ruleRegistries, ruleRegistry) <= 1) continue;
            throw new IllegalArgumentException("may not include duplicate registries");
        }
    }

    public int getPlannerTimeoutSec() {
        return this.plannerTimeoutSec;
    }

    public void setPlannerTimeoutSec(int plannerTimeoutSec) {
        this.plannerTimeoutSec = plannerTimeoutSec;
    }

    public boolean isIgnoreFailed() {
        return this.ignoreFailed;
    }

    public void setIgnoreFailed(boolean ignoreFailed) {
        this.ignoreFailed = ignoreFailed;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        if (select == null) {
            throw new IllegalArgumentException("select may not be null");
        }
        this.select = select;
    }

    public Comparator<RuleResult> getPlanComparator() {
        return this.planComparator;
    }

    public void setPlanComparator(Comparator<RuleResult> planComparator) {
        if (planComparator == null) {
            throw new IllegalArgumentException("planComparator may not be null");
        }
        this.planComparator = planComparator;
    }

    public int size() {
        return this.ruleRegistries.size();
    }

    public RuleRegistry findRegistryWith(String ruleName) {
        for (RuleRegistry ruleRegistry : this.ruleRegistries) {
            if (!ruleRegistry.hasRule(ruleName)) continue;
            return ruleRegistry;
        }
        return null;
    }

    protected int indexOf(RuleRegistry ruleRegistry) {
        return this.ruleRegistries.indexOf(ruleRegistry);
    }

    public static enum Select {
        FIRST,
        COMPARED;

    }
}

