/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.rule;

import cascading.flow.planner.iso.transformer.ElementFactory;
import cascading.flow.planner.rule.PlanPhase;
import cascading.flow.planner.rule.ProcessLevel;
import cascading.flow.planner.rule.Rule;
import cascading.flow.planner.rule.util.RuleLogUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RuleRegistry {
    private Map<String, ElementFactory> factories = new HashMap<String, ElementFactory>();
    private Map<PlanPhase, LinkedList<Rule>> rules = new HashMap<PlanPhase, LinkedList<Rule>>();
    private String[] logLevels;
    private boolean resolveElementsEnabled;

    public RuleRegistry() {
        for (PlanPhase phase : PlanPhase.values()) {
            this.rules.put(phase, new LinkedList());
        }
        this.resolveElementsEnabled = true;
    }

    public void enableDebugLogging() {
        this.logLevels = RuleLogUtil.enableDebugLogging();
    }

    public void restoreLogging() {
        if (this.logLevels != null) {
            RuleLogUtil.restoreLogging(this.logLevels);
        }
    }

    public boolean addDefaultElementFactory(String name, ElementFactory elementFactory) {
        if (this.hasElementFactory(name)) {
            return false;
        }
        this.factories.put(name, elementFactory);
        return true;
    }

    public ElementFactory addElementFactory(String name, ElementFactory elementFactory) {
        return this.factories.put(name, elementFactory);
    }

    public ElementFactory getElementFactory(String factoryName) {
        return this.factories.get(factoryName);
    }

    public boolean hasElementFactory(String factoryName) {
        return this.factories.containsKey(factoryName);
    }

    public LinkedList<Rule> getRulesFor(PlanPhase phase) {
        return this.rules.get((Object)phase);
    }

    public boolean addRule(Rule rule) {
        if (rule.getRulePhase() == null) {
            throw new IllegalArgumentException("rule must have a rule phase: " + rule.getRuleName());
        }
        return this.rules.get((Object)rule.getRulePhase()).add(rule);
    }

    public boolean hasRule(String ruleName) {
        for (Map.Entry<PlanPhase, LinkedList<Rule>> entry : this.rules.entrySet()) {
            for (Rule rule : entry.getValue()) {
                if (!rule.getRuleName().equals(ruleName)) continue;
                return true;
            }
        }
        return false;
    }

    public void setResolveElementsEnabled(boolean resolveElementsEnabled) {
        this.resolveElementsEnabled = resolveElementsEnabled;
    }

    public boolean enabledResolveElements() {
        return this.resolveElementsEnabled;
    }

    public Set<ProcessLevel> getProcessLevels() {
        TreeSet<ProcessLevel> processLevels = new TreeSet<ProcessLevel>();
        for (PlanPhase planPhase : this.rules.keySet()) {
            if (this.rules.get((Object)planPhase).isEmpty()) continue;
            processLevels.add(planPhase.getLevel());
        }
        return processLevels;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RuleRegistry that = (RuleRegistry)object;
        if (this.resolveElementsEnabled != that.resolveElementsEnabled) {
            return false;
        }
        if (this.factories != null ? !this.factories.equals(that.factories) : that.factories != null) {
            return false;
        }
        return !(this.rules != null ? !this.rules.equals(that.rules) : that.rules != null);
    }

    public int hashCode() {
        int result = this.factories != null ? this.factories.hashCode() : 0;
        result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
        result = 31 * result + (this.resolveElementsEnabled ? 1 : 0);
        return result;
    }
}

