/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.rule;

import cascading.flow.FlowElement;
import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.subgraph.GraphPartitioner;
import cascading.flow.planner.iso.subgraph.Partitions;
import cascading.flow.planner.rule.PlanPhase;
import cascading.flow.planner.rule.Rule;
import cascading.flow.planner.rule.util.LogLevel;
import cascading.flow.planner.rule.util.RuleLogUtil;
import java.util.Collection;

public abstract class RulePartitioner
implements Rule {
    protected LogLevel logLevel;
    protected PlanPhase phase;
    protected PartitionSource partitionSource = PartitionSource.PartitionParent;
    protected GraphPartitioner graphPartitioner;

    public abstract Enum[] getAnnotationExcludes();

    public RulePartitioner(PlanPhase phase, PartitionSource partitionSource, GraphPartitioner graphPartitioner) {
        this(null, phase, partitionSource, graphPartitioner);
    }

    public RulePartitioner(LogLevel logLevel, PlanPhase phase, PartitionSource partitionSource, GraphPartitioner graphPartitioner) {
        this.logLevel = logLevel;
        this.phase = phase;
        this.partitionSource = partitionSource;
        this.graphPartitioner = graphPartitioner;
    }

    public RulePartitioner() {
    }

    @Override
    public PlanPhase getRulePhase() {
        return this.phase;
    }

    public PartitionSource getPartitionSource() {
        return this.partitionSource;
    }

    protected GraphPartitioner getGraphPartitioner() {
        return this.graphPartitioner;
    }

    public Partitions partition(PlannerContext plannerContext, ElementGraph elementGraph) {
        return this.partition(plannerContext, elementGraph, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Partitions partition(PlannerContext plannerContext, ElementGraph elementGraph, Collection<FlowElement> excludes) {
        String[] logLevels = RuleLogUtil.enableLogging(this.logLevel);
        try {
            Partitions partitions = this.performPartition(plannerContext, elementGraph, excludes);
            return partitions;
        }
        finally {
            RuleLogUtil.restoreLogging(logLevels);
        }
    }

    public Partitions performPartition(PlannerContext plannerContext, ElementGraph elementGraph, Collection<FlowElement> excludes) {
        Partitions partitions = this.getGraphPartitioner().partition(plannerContext, elementGraph, excludes);
        if (partitions != null) {
            partitions.setRulePartitioner(this);
        }
        return partitions;
    }

    @Override
    public String getRuleName() {
        return this.getClass().getSimpleName().replaceAll("^(.*)[]A-Z][a-z]*Rule$", "$1");
    }

    public String toString() {
        return this.getRuleName();
    }

    public static enum PartitionSource {
        PartitionParent,
        PartitionCurrent;

    }
}

