/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.rule;

import cascading.flow.FlowElement;
import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.PlannerException;
import cascading.flow.planner.graph.AnnotatedGraph;
import cascading.flow.planner.graph.BoundedElementMultiGraph;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.graph.ElementMultiGraph;
import cascading.flow.planner.graph.FlowElementGraph;
import cascading.flow.planner.graph.IgnoreAnnotationsHashSet;
import cascading.flow.planner.iso.GraphResult;
import cascading.flow.planner.iso.assertion.Asserted;
import cascading.flow.planner.iso.assertion.GraphAssert;
import cascading.flow.planner.iso.subgraph.Partitions;
import cascading.flow.planner.iso.transformer.GraphTransformer;
import cascading.flow.planner.iso.transformer.Transformed;
import cascading.flow.planner.rule.PlanPhase;
import cascading.flow.planner.rule.ProcessLevel;
import cascading.flow.planner.rule.Rule;
import cascading.flow.planner.rule.RulePartitioner;
import cascading.flow.planner.rule.RuleRegistry;
import cascading.flow.planner.rule.RuleResult;
import cascading.flow.planner.rule.ScopeResolver;
import cascading.flow.planner.rule.TransformException;
import cascading.flow.planner.rule.UnsupportedPlanException;
import cascading.flow.planner.rule.util.TraceWriter;
import cascading.util.EnumMultiMap;
import cascading.util.ProcessLogger;
import cascading.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RuleExec {
    private static final int ELEMENT_THRESHOLD = 600;
    final TraceWriter traceWriter;
    final RuleRegistry registry;

    public RuleExec(TraceWriter traceWriter, RuleRegistry registry) {
        this.traceWriter = traceWriter;
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleResult exec(PlannerContext plannerContext, FlowElementGraph flowElementGraph) {
        boolean logAsInfo;
        RuleResult ruleResult = new RuleResult(this.registry, flowElementGraph);
        ProcessLogger logger = plannerContext.getLogger();
        int size = flowElementGraph.vertexSet().size();
        boolean bl = logAsInfo = size >= 600;
        if (logAsInfo) {
            logger.logInfo("elements in graph: {}, info logging threshold: {}, logging planner execution status", size, 600);
        }
        long beginExec = System.currentTimeMillis();
        try {
            this.planPhases(plannerContext, logAsInfo, ruleResult);
        }
        catch (Exception exception) {
            try {
                ruleResult.setPlannerException(exception);
            }
            catch (Throwable throwable) {
                long endExec = System.currentTimeMillis();
                ruleResult.setDuration(beginExec, endExec);
                RuleResult.ResultStatus status = ruleResult.getResultStatus();
                String duration = Util.formatDurationFromMillis(endExec - beginExec);
                this.logPhase(logger, logAsInfo, "rule registry completed: {}, with status: {}, and duration: {}", new Object[]{this.registry.getName(), status, duration});
                throw throwable;
            }
            long endExec = System.currentTimeMillis();
            ruleResult.setDuration(beginExec, endExec);
            RuleResult.ResultStatus status = ruleResult.getResultStatus();
            String duration = Util.formatDurationFromMillis(endExec - beginExec);
            this.logPhase(logger, logAsInfo, "rule registry completed: {}, with status: {}, and duration: {}", new Object[]{this.registry.getName(), status, duration});
        }
        long endExec = System.currentTimeMillis();
        ruleResult.setDuration(beginExec, endExec);
        RuleResult.ResultStatus status = ruleResult.getResultStatus();
        String duration = Util.formatDurationFromMillis(endExec - beginExec);
        this.logPhase(logger, logAsInfo, "rule registry completed: {}, with status: {}, and duration: {}", new Object[]{this.registry.getName(), status, duration});
        return ruleResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void planPhases(PlannerContext plannerContext, boolean logAsInfo, RuleResult ruleResult) {
        ProcessLogger logger = plannerContext.getLogger();
        PlanPhase[] planPhaseArray = PlanPhase.values();
        int n = planPhaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlanPhase phase = planPhaseArray[n2];
            long beginPhase = System.currentTimeMillis();
            this.logPhase(logger, logAsInfo, "starting rule phase: {}", new Object[]{phase});
            try {
                switch (phase.getAction()) {
                    case Resolve: {
                        this.resolveElements(ruleResult);
                        break;
                    }
                    case Rule: {
                        this.executeRulePhase(phase, plannerContext, ruleResult);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                long endPhase = System.currentTimeMillis();
                ruleResult.setPhaseDuration(phase, beginPhase, endPhase);
                this.logPhase(logger, logAsInfo, "ending rule phase: {}, duration: {}", new Object[]{phase, Util.formatDurationFromMillis(endPhase - beginPhase)});
                throw throwable;
            }
            long endPhase = System.currentTimeMillis();
            ruleResult.setPhaseDuration(phase, beginPhase, endPhase);
            this.logPhase(logger, logAsInfo, "ending rule phase: {}, duration: {}", new Object[]{phase, Util.formatDurationFromMillis(endPhase - beginPhase)});
            ++n2;
        }
        return;
    }

    private void resolveElements(RuleResult ruleResult) {
        if (!this.registry.enabledResolveElements()) {
            return;
        }
        FlowElementGraph elementGraph = ruleResult.getAssemblyGraph();
        elementGraph = (FlowElementGraph)elementGraph.copyElementGraph();
        ScopeResolver.resolveFields(elementGraph);
        ruleResult.setLevelResults(ProcessLevel.Assembly, (ElementGraph)ruleResult.initialAssembly, elementGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RuleResult executeRulePhase(PlanPhase phase, PlannerContext plannerContext, RuleResult ruleResult) {
        RuleResult ruleResult2;
        ProcessLogger logger = plannerContext.getLogger();
        logger.logDebug("executing plan phase: {}", new Object[]{phase});
        LinkedList<Rule> rules = this.registry.getRulesFor(phase);
        this.writePhaseInitPlan(phase, ruleResult);
        try {
            for (Rule rule : rules) {
                logger.logDebug("executing rule: {}", rule);
                long begin = System.currentTimeMillis();
                try {
                    switch (phase.getMode()) {
                        case Mutate: {
                            this.performMutation(plannerContext, ruleResult, phase, rule);
                            break;
                        }
                        case Partition: {
                            this.performPartition(plannerContext, ruleResult, phase, rule);
                            break;
                        }
                    }
                }
                catch (UnsupportedPlanException exception) {
                    try {
                        logger.logDebug("executing rule failed: {}, message: {}", rule, exception.getMessage());
                        throw new UnsupportedPlanException(rule, exception);
                        catch (PlannerException exception2) {
                            logger.logDebug("executing rule failed: {}, message: {}", rule, exception2.getMessage());
                            throw exception2;
                        }
                        catch (Exception exception3) {
                            logger.logDebug("executing rule failed: {}, message: {}", rule, exception3.getMessage());
                            throw new PlannerException(this.registry, phase, rule, (Throwable)exception3);
                        }
                    }
                    catch (Throwable throwable) {
                        long end = System.currentTimeMillis();
                        ruleResult.setRuleDuration(rule, begin, end);
                        logger.logDebug("completed rule: {}", rule);
                        throw throwable;
                    }
                }
                long end = System.currentTimeMillis();
                ruleResult.setRuleDuration(rule, begin, end);
                logger.logDebug("completed rule: {}", rule);
            }
            ruleResult2 = ruleResult;
        }
        catch (Throwable throwable) {
            logger.logDebug("completed plan phase: {}", new Object[]{phase});
            this.writePhaseResultPlan(phase, ruleResult);
            throw throwable;
        }
        logger.logDebug("completed plan phase: {}", new Object[]{phase});
        this.writePhaseResultPlan(phase, ruleResult);
        return ruleResult2;
    }

    protected void performMutation(PlannerContext plannerContext, RuleResult ruleResult, PlanPhase phase, Rule rule) {
        if (rule instanceof GraphTransformer) {
            this.performTransform(plannerContext, ruleResult, phase, (GraphTransformer)((Object)rule));
        } else if (rule instanceof GraphAssert) {
            this.performAssertion(plannerContext, ruleResult, phase, (GraphAssert)((Object)rule));
        } else {
            throw new PlannerException("unexpected rule: " + rule.getRuleName());
        }
    }

    private void performPartition(PlannerContext plannerContext, RuleResult ruleResult, PlanPhase phase, Rule rule) {
        if (!(rule instanceof RulePartitioner)) {
            throw new PlannerException("unexpected rule: " + rule.getRuleName());
        }
        RulePartitioner partitioner = (RulePartitioner)rule;
        if (partitioner.getPartitionSource() == RulePartitioner.PartitionSource.PartitionParent) {
            this.handleParentPartitioning(plannerContext, ruleResult, phase, partitioner);
        } else if (partitioner.getPartitionSource() == RulePartitioner.PartitionSource.PartitionCurrent) {
            this.handleCurrentPartitioning(plannerContext, ruleResult, phase, partitioner);
        } else {
            throw new IllegalStateException("unknown partitioning type: " + (Object)((Object)partitioner.getPartitionSource()));
        }
    }

    private void handleCurrentPartitioning(PlannerContext plannerContext, RuleResult ruleResult, PlanPhase phase, RulePartitioner partitioner) {
        Map<ElementGraph, List<? extends ElementGraph>> priorResults = ruleResult.getLevelResults(phase.getLevel());
        LinkedHashMap<ElementGraph, List<? extends ElementGraph>> subGraphs = new LinkedHashMap<ElementGraph, List<? extends ElementGraph>>();
        for (Map.Entry<ElementGraph, List<? extends ElementGraph>> entry : priorResults.entrySet()) {
            ElementGraph parent = entry.getKey();
            List<? extends ElementGraph> priors = entry.getValue();
            List<ElementGraph> resultChildren = new ArrayList<ElementGraph>(priors);
            Set<FlowElement> exclusions = this.getExclusions(priors, partitioner.getAnnotationExcludes());
            for (ElementGraph elementGraph : priors) {
                Partitions partitions;
                ElementGraph priorAnnotated = this.annotateWithPriors(elementGraph, priors);
                try {
                    partitions = partitioner.partition(plannerContext, priorAnnotated, exclusions);
                }
                catch (Throwable throwable) {
                    throw new PlannerException(this.registry, phase, partitioner, priorAnnotated, throwable);
                }
                this.writeTransformTrace(ruleResult, phase, partitioner, parent, elementGraph, partitions);
                List<ElementGraph> results = this.makeBoundedOn(ruleResult.getAssemblyGraph(), partitions.getAnnotatedSubGraphs());
                if (results.isEmpty()) continue;
                IgnoreAnnotationsHashSet uniques = new IgnoreAnnotationsHashSet((Collection<? extends ElementGraph>)results);
                if (uniques.size() != results.size()) {
                    throw new PlannerException("rule created duplicate element graphs");
                }
                resultChildren.remove(elementGraph);
                for (ElementGraph elementGraph2 : resultChildren) {
                    if (uniques.add(elementGraph2)) continue;
                    plannerContext.getLogger().logDebug("re-partition rule created duplicate element graph to prior partitioner: {}, replacing duplicate result", partitioner.getRuleName());
                }
                resultChildren = uniques.asList();
            }
            subGraphs.put(parent, resultChildren);
        }
        ruleResult.setLevelResults(phase.getLevel(), subGraphs);
    }

    private void handleParentPartitioning(PlannerContext plannerContext, RuleResult ruleResult, PlanPhase phase, RulePartitioner partitioner) {
        Map<ElementGraph, List<? extends ElementGraph>> priorResults = ruleResult.getLevelResults(phase.getLevel());
        LinkedHashMap<ElementGraph, List<? extends ElementGraph>> subGraphs = new LinkedHashMap<ElementGraph, List<? extends ElementGraph>>();
        for (Map.Entry<ElementGraph, List<? extends ElementGraph>> entry : priorResults.entrySet()) {
            Partitions partitions;
            ElementGraph parent = entry.getKey();
            List<? extends ElementGraph> priors = entry.getValue();
            Set<FlowElement> exclusions = this.getExclusions(priors, partitioner.getAnnotationExcludes());
            ElementGraph priorAnnotated = this.annotateWithPriors(parent, priors);
            try {
                partitions = partitioner.partition(plannerContext, priorAnnotated, exclusions);
            }
            catch (Throwable throwable) {
                throw new PlannerException(this.registry, phase, partitioner, priorAnnotated, throwable);
            }
            this.writeTransformTrace(ruleResult, phase, partitioner, parent, null, partitions);
            List<ElementGraph> results = this.makeBoundedOn(ruleResult.getAssemblyGraph(), partitions.getAnnotatedSubGraphs());
            IgnoreAnnotationsHashSet uniques = new IgnoreAnnotationsHashSet((Collection<? extends ElementGraph>)results);
            if (uniques.size() != results.size()) {
                throw new PlannerException("rule created duplicate element graphs");
            }
            for (ElementGraph elementGraph : priors) {
                if (uniques.add(elementGraph)) continue;
                plannerContext.getLogger().logDebug("partition rule created duplicate element graph to prior partitioner: {}, replacing duplicate result", partitioner.getRuleName());
            }
            subGraphs.put(parent, uniques.asList());
        }
        ruleResult.setLevelResults(phase.getLevel(), subGraphs);
    }

    private void performAssertion(PlannerContext plannerContext, RuleResult ruleResult, PlanPhase phase, GraphAssert asserter) {
        plannerContext.getLogger().logDebug("applying assertion: {}", ((Rule)((Object)asserter)).getRuleName());
        Map<ElementGraph, List<? extends ElementGraph>> levelResults = ruleResult.getLevelResults(phase.getLevel());
        for (Map.Entry<ElementGraph, List<? extends ElementGraph>> entry : levelResults.entrySet()) {
            ElementGraph parent = entry.getKey();
            List<? extends ElementGraph> children = entry.getValue();
            for (ElementGraph elementGraph : children) {
                Asserted asserted;
                try {
                    asserted = asserter.assertion(plannerContext, elementGraph);
                }
                catch (Throwable throwable) {
                    throw new PlannerException(this.registry, phase, (Rule)((Object)asserter), elementGraph, throwable);
                }
                this.writeTransformTrace(ruleResult, phase, (Rule)((Object)asserter), parent, elementGraph, asserted);
                FlowElement primary = asserted.getFirstAnchor();
                if (primary == null) continue;
                if (asserted.getAssertionType() == GraphAssert.AssertionType.Unsupported) {
                    throw new UnsupportedPlanException(asserted.getFirstAnchor(), asserted.getMessage());
                }
                throw new PlannerException(asserted.getFirstAnchor(), asserted.getMessage());
            }
        }
    }

    private void performTransform(PlannerContext plannerContext, RuleResult ruleResult, PlanPhase phase, GraphTransformer transformer) {
        plannerContext.getLogger().logDebug("applying transform: {}", ((Rule)((Object)transformer)).getRuleName());
        Map<ElementGraph, List<? extends ElementGraph>> levelResults = ruleResult.getLevelResults(phase.getLevel());
        for (Map.Entry<ElementGraph, List<? extends ElementGraph>> entry : levelResults.entrySet()) {
            ElementGraph parent = entry.getKey();
            List<? extends ElementGraph> children = entry.getValue();
            ArrayList<ElementGraph> results = new ArrayList<ElementGraph>();
            for (ElementGraph elementGraph : children) {
                Transformed transformed;
                try {
                    transformed = transformer.transform(plannerContext, elementGraph);
                }
                catch (TransformException exception) {
                    this.writeTransformTrace(ruleResult, phase, (Rule)((Object)transformer), parent, elementGraph, exception.getTransformed());
                    throw new PlannerException(this.registry, phase, (Rule)((Object)transformer), elementGraph, exception.getCause());
                }
                catch (Throwable throwable) {
                    throw new PlannerException(this.registry, phase, (Rule)((Object)transformer), elementGraph, throwable);
                }
                this.writeTransformTrace(ruleResult, phase, (Rule)((Object)transformer), parent, elementGraph, transformed);
                Object endGraph = transformed.getEndGraph();
                if (endGraph == null) {
                    results.add(elementGraph);
                    continue;
                }
                if (ElementGraphs.isEmpty(endGraph)) continue;
                results.add((ElementGraph)endGraph);
            }
            ruleResult.setLevelResults(phase.getLevel(), parent, results);
        }
    }

    private ElementGraph annotateWithPriors(ElementGraph elementGraph, List<? extends ElementGraph> priorResults) {
        if (priorResults == null) {
            return elementGraph;
        }
        ElementMultiGraph resultGraph = new ElementMultiGraph(elementGraph);
        for (ElementGraph elementGraph2 : priorResults) {
            if (!(elementGraph2 instanceof AnnotatedGraph) || !((AnnotatedGraph)((Object)elementGraph2)).hasAnnotations()) continue;
            EnumMultiMap<FlowElement> annotations = ((AnnotatedGraph)((Object)elementGraph2)).getAnnotations();
            resultGraph.getAnnotations().addAll(annotations);
        }
        return resultGraph;
    }

    private Set<FlowElement> getExclusions(List<? extends ElementGraph> elementGraphs, Enum[] annotationExcludes) {
        if (elementGraphs == null) {
            return null;
        }
        Set<FlowElement> exclusions = Util.createIdentitySet();
        for (ElementGraph elementGraph : elementGraphs) {
            if (!(elementGraph instanceof AnnotatedGraph) || !((AnnotatedGraph)((Object)elementGraph)).hasAnnotations()) continue;
            for (Enum annotationExclude : annotationExcludes) {
                Set flowElements = (Set)((AnnotatedGraph)((Object)elementGraph)).getAnnotations().getValues(annotationExclude);
                if (flowElements == null) continue;
                exclusions.addAll(flowElements);
            }
        }
        return exclusions;
    }

    private List<ElementGraph> makeBoundedOn(ElementGraph currentElementGraph, Map<ElementGraph, EnumMultiMap> subGraphs) {
        ArrayList<ElementGraph> results = new ArrayList<ElementGraph>(subGraphs.size());
        for (ElementGraph subGraph : subGraphs.keySet()) {
            results.add(new BoundedElementMultiGraph(currentElementGraph, subGraph, subGraphs.get(subGraph)));
        }
        return results;
    }

    private void writePhaseInitPlan(PlanPhase phase, RuleResult ruleResult) {
        switch (phase.getLevel()) {
            case Assembly: {
                this.traceWriter.writeTransformPlan(this.registry.getName(), ruleResult.getAssemblyGraph(), String.format("%02d-%s-init.dot", new Object[]{phase.ordinal(), phase}));
                break;
            }
            case Step: {
                break;
            }
            case Node: {
                break;
            }
        }
    }

    private void writePhaseResultPlan(PlanPhase phase, RuleResult ruleResult) {
        switch (phase.getLevel()) {
            case Assembly: {
                this.traceWriter.writeTransformPlan(this.registry.getName(), ruleResult.getAssemblyGraph(), String.format("%02d-%s-result.dot", new Object[]{phase.ordinal(), phase}));
                break;
            }
            case Step: {
                this.traceWriter.writeTransformPlan(this.registry.getName(), ruleResult.getAssemblyToStepGraphMap().get(ruleResult.getAssemblyGraph()), phase, "result");
                break;
            }
            case Node: {
                this.traceWriter.writeTransformPlan(this.registry.getName(), ruleResult.getStepToNodeGraphMap(), phase, "result");
                break;
            }
            case Pipeline: {
                this.traceWriter.writeTransformPlan(this.registry.getName(), ruleResult.getStepToNodeGraphMap(), ruleResult.getNodeToPipelineGraphMap(), phase, "result");
            }
        }
    }

    private void logPhase(ProcessLogger logger, boolean logAsInfo, String message, Object ... items) {
        if (logAsInfo) {
            logger.logInfo(message, items);
        } else {
            logger.logDebug(message, items);
        }
    }

    private void writeTransformTrace(RuleResult ruleResult, PlanPhase phase, Rule rule, ElementGraph parent, ElementGraph child, GraphResult result) {
        if (this.traceWriter.isTransformTraceDisabled()) {
            return;
        }
        int[] path = child != null ? ruleResult.getPathFor(parent, child) : ruleResult.getPathFor(parent);
        this.traceWriter.writeTransformPlan(this.registry.getName(), phase, rule, path, result);
    }
}

