/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.rule;

import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.assertion.GraphAssert;
import cascading.flow.planner.iso.transformer.ContractedTransformer;
import cascading.flow.planner.iso.transformer.SubGraphTransformer;
import cascading.flow.planner.iso.transformer.Transformed;
import cascading.flow.planner.rule.PlanPhase;
import cascading.flow.planner.rule.Rule;
import cascading.flow.planner.rule.RuleExpression;

public class RuleAssert
extends GraphAssert<ElementGraph>
implements Rule {
    private final PlanPhase phase;
    private final RuleExpression ruleExpression;
    private ContractedTransformer contractedTransformer;
    private SubGraphTransformer subGraphTransformer;

    public RuleAssert(PlanPhase phase, RuleExpression ruleExpression, String message) {
        this(phase, ruleExpression, message, null);
    }

    public RuleAssert(PlanPhase phase, RuleExpression ruleExpression, String message, GraphAssert.AssertionType assertionType) {
        super(ruleExpression.getMatchExpression(), message, assertionType);
        this.phase = phase;
        this.ruleExpression = ruleExpression;
        this.contractedTransformer = ruleExpression.getContractionExpression() != null ? new ContractedTransformer(ruleExpression.getContractionExpression()) : null;
        if (ruleExpression.getContractedMatchExpression() != null) {
            if (this.contractedTransformer == null) {
                throw new IllegalArgumentException("must have contracted expression if given contracted match expression");
            }
            this.subGraphTransformer = new SubGraphTransformer(this.contractedTransformer, ruleExpression.getContractedMatchExpression());
        } else {
            this.subGraphTransformer = null;
        }
    }

    @Override
    public PlanPhase getRulePhase() {
        return this.phase;
    }

    @Override
    public String getRuleName() {
        return this.getClass().getSimpleName().replaceAll("^(.*)[A-Z][a-z]*Rule$", "$1");
    }

    @Override
    protected Transformed<ElementGraph> transform(PlannerContext plannerContext, ElementGraph graph) {
        Transformed<ElementGraph> transformed = null;
        if (this.contractedTransformer != null) {
            transformed = this.contractedTransformer.transform(plannerContext, graph);
        } else if (this.subGraphTransformer != null) {
            transformed = this.subGraphTransformer.transform(plannerContext, graph);
        }
        return transformed;
    }

    public String toString() {
        return this.getRuleName();
    }
}

