/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.rule;

import cascading.flow.planner.rule.ExecAction;
import cascading.flow.planner.rule.ProcessLevel;
import cascading.flow.planner.rule.RuleMode;

public enum PlanPhase {
    PreBalanceAssembly(ProcessLevel.Assembly, RuleMode.Mutate, ExecAction.Rule),
    BalanceAssembly(ProcessLevel.Assembly, RuleMode.Mutate, ExecAction.Rule),
    PostBalanceAssembly(ProcessLevel.Assembly, RuleMode.Mutate, ExecAction.Rule),
    PreResolveAssembly(ProcessLevel.Assembly, RuleMode.Mutate, ExecAction.Rule),
    ResolveAssembly(ProcessLevel.Assembly, RuleMode.Mutate, ExecAction.Resolve),
    PostResolveAssembly(ProcessLevel.Assembly, RuleMode.Mutate, ExecAction.Rule),
    PartitionSteps(ProcessLevel.Step, RuleMode.Partition, ExecAction.Rule),
    PostSteps(ProcessLevel.Step, RuleMode.Mutate, ExecAction.Rule),
    PartitionNodes(ProcessLevel.Node, RuleMode.Partition, ExecAction.Rule),
    PostNodes(ProcessLevel.Node, RuleMode.Mutate, ExecAction.Rule),
    PartitionPipelines(ProcessLevel.Pipeline, RuleMode.Partition, ExecAction.Rule),
    PostPipelines(ProcessLevel.Pipeline, RuleMode.Mutate, ExecAction.Rule);

    ProcessLevel level;
    ExecAction action;
    RuleMode mode;

    private PlanPhase(ProcessLevel level, RuleMode mode, ExecAction action) {
        this.level = level;
        this.action = action;
        this.mode = mode;
    }

    public ProcessLevel getLevel() {
        return this.level;
    }

    public ExecAction getAction() {
        return this.action;
    }

    public RuleMode getMode() {
        return this.mode;
    }
}

