/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.process;

import cascading.flow.FlowElement;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.process.ProcessEdge;
import cascading.flow.planner.process.ProcessModel;
import cascading.tap.Tap;
import cascading.util.EnumMultiMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ProcessGraph<Process extends ProcessModel>
extends Serializable {
    public boolean addVertex(Process var1);

    public Set<ProcessEdge> getAllEdges(Process var1, Process var2);

    public ProcessEdge getEdge(Process var1, Process var2);

    public ProcessEdge addEdge(Process var1, Process var2);

    public boolean addEdge(Process var1, Process var2, ProcessEdge var3);

    public boolean containsEdge(Process var1, Process var2);

    public boolean containsEdge(ProcessEdge var1);

    public boolean containsVertex(Process var1);

    public Set<ProcessEdge> edgeSet();

    public Set<ProcessEdge> edgesOf(Process var1);

    public boolean removeAllEdges(Collection<? extends ProcessEdge> var1);

    public Set<ProcessEdge> removeAllEdges(Process var1, Process var2);

    public boolean removeAllVertices(Collection<? extends Process> var1);

    public ProcessEdge removeEdge(Process var1, Process var2);

    public boolean removeEdge(ProcessEdge var1);

    public boolean removeVertex(Process var1);

    public Set<Process> vertexSet();

    public Process getEdgeSource(ProcessEdge var1);

    public Process getEdgeTarget(ProcessEdge var1);

    public double getEdgeWeight(ProcessEdge var1);

    public int inDegreeOf(Process var1);

    public Set<ProcessEdge> incomingEdgesOf(Process var1);

    public int outDegreeOf(Process var1);

    public Set<ProcessEdge> outgoingEdgesOf(Process var1);

    public Set<FlowElement> getSourceElements();

    public Set<FlowElement> getSinkElements();

    public Set<Tap> getSourceTaps();

    public Map<String, Tap> getSourceTapsMap();

    public Set<Tap> getSinkTaps();

    public Map<String, Tap> getSinkTapsMap();

    public Map<String, Tap> getTrapsMap();

    public Iterator<Process> getTopologicalIterator();

    public Iterator<Process> getOrdinalTopologicalIterator();

    public Iterator<Process> getOrderedTopologicalIterator(Comparator<Process> var1);

    public Set<ElementGraph> getElementGraphs();

    public List<ElementGraph> getElementGraphs(FlowElement var1);

    public List<Process> getElementProcesses(FlowElement var1);

    public List<ElementGraph> getElementGraphs(Scope var1);

    public List<Process> getElementProcesses(Scope var1);

    public List<Process> getElementSourceProcesses(FlowElement var1);

    public List<Process> getElementSinkProcesses(FlowElement var1);

    public Set<FlowElement> getAllSourceElements();

    public Set<FlowElement> getAllSinkElements();

    public EnumMultiMap<FlowElement> getAnnotations();

    public Set<FlowElement> getDuplicatedElements(ElementGraph var1);

    public Set<ElementGraph> getIdentityElementGraphs();

    public Set<Process> getIdentityProcesses();

    public void writeDOT(String var1);

    public void writeDOTNested(String var1, ElementGraph var2);
}

