/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.process;

import cascading.flow.FlowElement;
import cascading.flow.FlowElements;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.AnnotatedGraph;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.process.ProcessModel;
import cascading.tuple.Fields;
import cascading.util.Util;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ProcessEdge<Process extends ProcessModel>
implements Serializable {
    String id;
    String sourceProcessID;
    String sinkProcessID;
    FlowElement flowElement;
    Set<Integer> sourceProvidedOrdinals;
    Set<Integer> sinkExpectedOrdinals;
    Map<Integer, Fields> resolvedKeyFields;
    Map<Integer, Fields> resolvedSortFields;
    Map<Integer, Fields> resolvedValueFields;
    Set<Enum> sinkAnnotations = Collections.emptySet();
    Set<Enum> sourceAnnotations = Collections.emptySet();
    Map<String, String> edgeAnnotations;

    public ProcessEdge(Process sourceProcess, FlowElement flowElement, Process sinkProcess) {
        this(sourceProcess.getElementGraph(), flowElement, sinkProcess.getElementGraph());
        this.sourceProcessID = sourceProcess.getID();
        this.sinkProcessID = sinkProcess.getID();
    }

    public ProcessEdge(ElementGraph sourceElementGraph, FlowElement flowElement, ElementGraph sinkElementGraph) {
        this.flowElement = flowElement;
        this.sourceProvidedOrdinals = this.createOrdinals(sourceElementGraph.incomingEdgesOf(flowElement));
        this.sinkExpectedOrdinals = this.createOrdinals(sinkElementGraph.incomingEdgesOf(flowElement));
        this.setResolvedFields(sourceElementGraph, flowElement, sinkElementGraph);
        if (sourceElementGraph instanceof AnnotatedGraph && ((AnnotatedGraph)((Object)sourceElementGraph)).hasAnnotations()) {
            this.sourceAnnotations = ((AnnotatedGraph)((Object)sourceElementGraph)).getAnnotations().getKeysFor(flowElement);
        }
        if (sinkElementGraph instanceof AnnotatedGraph && ((AnnotatedGraph)((Object)sinkElementGraph)).hasAnnotations()) {
            this.sinkAnnotations = ((AnnotatedGraph)((Object)sinkElementGraph)).getAnnotations().getKeysFor(flowElement);
        }
    }

    public ProcessEdge(Process sourceProcess, Process sinkProcess) {
        this.sourceProcessID = sourceProcess.getID();
        this.sinkProcessID = sinkProcess.getID();
    }

    public String getID() {
        if (this.id == null) {
            this.id = Util.createUniqueID();
        }
        return this.id;
    }

    public String getSourceProcessID() {
        return this.sourceProcessID;
    }

    public String getSinkProcessID() {
        return this.sinkProcessID;
    }

    private void setResolvedFields(ElementGraph sourceElementGraph, FlowElement flowElement, ElementGraph sinkElementGraph) {
        Set<Scope> outgoingScopes = sourceElementGraph.outgoingEdgesOf(flowElement);
        Scope resolvedScope = Util.getFirst(outgoingScopes);
        Set<Scope> incomingScopes = sinkElementGraph.incomingEdgesOf(flowElement);
        this.resolvedKeyFields = new HashMap<Integer, Fields>();
        this.resolvedSortFields = new HashMap<Integer, Fields>();
        this.resolvedValueFields = new HashMap<Integer, Fields>();
        for (Scope incomingScope : incomingScopes) {
            Fields value;
            int ordinal = incomingScope.getOrdinal();
            if (resolvedScope.getKeySelectors() == null) {
                this.resolvedKeyFields.put(ordinal, incomingScope.getIncomingSpliceFields());
            } else if (resolvedScope.getKeySelectors() != null && (value = resolvedScope.getKeySelectors().get(incomingScope.getName())) != null) {
                this.resolvedKeyFields.put(ordinal, value);
            }
            if (resolvedScope.getSortingSelectors() != null && (value = resolvedScope.getSortingSelectors().get(incomingScope.getName())) != null) {
                this.resolvedSortFields.put(ordinal, value);
            }
            if (resolvedScope.getKeySelectors() == null) continue;
            this.resolvedValueFields.put(ordinal, incomingScope.getIncomingSpliceFields());
        }
    }

    public Map<String, String> getEdgeAnnotations() {
        if (this.edgeAnnotations == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.edgeAnnotations);
    }

    public void addEdgeAnnotation(Enum annotation) {
        if (annotation == null) {
            return;
        }
        this.addEdgeAnnotation(annotation.getDeclaringClass().getName(), annotation.name());
    }

    public void addEdgeAnnotation(String key, String value) {
        if (this.edgeAnnotations == null) {
            this.edgeAnnotations = new HashMap<String, String>();
        }
        this.edgeAnnotations.put(key, value);
    }

    private Set<Integer> createOrdinals(Set<Scope> scopes) {
        TreeSet<Integer> ordinals = new TreeSet<Integer>();
        for (Scope scope : scopes) {
            ordinals.add(scope.getOrdinal());
        }
        return ordinals;
    }

    public FlowElement getFlowElement() {
        return this.flowElement;
    }

    public String getFlowElementID() {
        return FlowElements.id(this.flowElement);
    }

    public Set<Integer> getSinkExpectedOrdinals() {
        return this.sinkExpectedOrdinals;
    }

    public Set<Integer> getSourceProvidedOrdinals() {
        return this.sourceProvidedOrdinals;
    }

    public Map<Integer, Fields> getResolvedKeyFields() {
        return this.resolvedKeyFields;
    }

    public Map<Integer, Fields> getResolvedSortFields() {
        return this.resolvedSortFields;
    }

    public Map<Integer, Fields> getResolvedValueFields() {
        return this.resolvedValueFields;
    }

    public Set<Enum> getSinkAnnotations() {
        return this.sinkAnnotations;
    }

    public Set<Enum> getSourceAnnotations() {
        return this.sourceAnnotations;
    }
}

