/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.process;

import cascading.flow.FlowElement;
import cascading.flow.FlowStep;
import cascading.flow.planner.BaseFlowStep;
import cascading.flow.planner.graph.AnnotatedDecoratedElementGraph;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.FlowElementGraph;
import cascading.flow.planner.process.BaseProcessGraph;
import cascading.flow.planner.process.FlowNodeGraph;
import cascading.flow.planner.process.FlowStepFactory;
import cascading.util.EnumMultiMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FlowStepGraph
extends BaseProcessGraph<FlowStep> {
    public FlowStepGraph() {
    }

    public FlowStepGraph(FlowStepFactory flowStepFactory, FlowElementGraph flowElementGraph, Map<ElementGraph, List<? extends ElementGraph>> nodeSubGraphsMap) {
        this(flowStepFactory, flowElementGraph, nodeSubGraphsMap, null);
    }

    public FlowStepGraph(FlowStepFactory flowStepFactory, FlowElementGraph flowElementGraph, Map<ElementGraph, List<? extends ElementGraph>> nodeSubGraphsMap, Map<ElementGraph, List<? extends ElementGraph>> pipelineSubGraphsMap) {
        this.buildGraph(flowStepFactory, flowElementGraph, nodeSubGraphsMap, pipelineSubGraphsMap);
        Iterator iterator = this.getTopologicalIterator();
        int ordinal = 0;
        int size = this.vertexSet().size();
        while (iterator.hasNext()) {
            BaseFlowStep flowStep = (BaseFlowStep)iterator.next();
            flowStep.setOrdinal(ordinal++);
            flowStep.setName(flowStepFactory.makeFlowStepName(flowStep, size, flowStep.getOrdinal()));
        }
    }

    protected void buildGraph(FlowStepFactory flowStepFactory, FlowElementGraph flowElementGraph, Map<ElementGraph, List<? extends ElementGraph>> nodeSubGraphsMap, Map<ElementGraph, List<? extends ElementGraph>> pipelineSubGraphsMap) {
        for (ElementGraph stepSubGraph : nodeSubGraphsMap.keySet()) {
            List<? extends ElementGraph> nodeSubGraphs = nodeSubGraphsMap.get(stepSubGraph);
            FlowNodeGraph flowNodeGraph = this.createFlowNodeGraph(flowStepFactory, flowElementGraph, pipelineSubGraphsMap, nodeSubGraphs);
            EnumMultiMap<FlowElement> annotations = flowNodeGraph.getAnnotations();
            if (!annotations.isEmpty()) {
                stepSubGraph = new AnnotatedDecoratedElementGraph(stepSubGraph, annotations);
            }
            FlowStep flowStep = flowStepFactory.createFlowStep(stepSubGraph, flowNodeGraph);
            this.addVertex(flowStep);
        }
        this.bindEdges();
    }

    protected FlowNodeGraph createFlowNodeGraph(FlowStepFactory flowStepFactory, FlowElementGraph flowElementGraph, Map<ElementGraph, List<? extends ElementGraph>> pipelineSubGraphsMap, List<? extends ElementGraph> nodeSubGraphs) {
        return new FlowNodeGraph(flowStepFactory.getFlowNodeFactory(), flowElementGraph, nodeSubGraphs, pipelineSubGraphsMap);
    }
}

