/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.process;

import cascading.flow.FlowElement;
import cascading.flow.FlowNode;
import cascading.flow.planner.BaseFlowNode;
import cascading.flow.planner.BaseFlowNodeFactory;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.FlowElementGraph;
import cascading.flow.planner.process.BaseProcessGraph;
import cascading.flow.planner.process.FlowNodeFactory;
import cascading.util.Util;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlowNodeGraph
extends BaseProcessGraph<FlowNode> {
    public static final FlowNodeComparator FLOW_NODE_COMPARATOR = new FlowNodeComparator();

    public FlowNodeGraph() {
    }

    public FlowNodeGraph(FlowElementGraph flowElementGraph, List<? extends ElementGraph> nodeSubGraphs) {
        this(new BaseFlowNodeFactory(), flowElementGraph, nodeSubGraphs);
    }

    public FlowNodeGraph(FlowNodeFactory flowNodeFactory, List<? extends ElementGraph> nodeSubGraphs) {
        this(flowNodeFactory, null, nodeSubGraphs);
    }

    public FlowNodeGraph(FlowNodeFactory flowNodeFactory, FlowElementGraph flowElementGraph, List<? extends ElementGraph> nodeSubGraphs) {
        this(flowNodeFactory, flowElementGraph, nodeSubGraphs, Collections.emptyMap());
    }

    public FlowNodeGraph(FlowNodeFactory flowNodeFactory, FlowElementGraph flowElementGraph, List<? extends ElementGraph> nodeSubGraphs, Map<ElementGraph, List<? extends ElementGraph>> pipelineSubGraphsMap) {
        this.buildGraph(flowNodeFactory, flowElementGraph, nodeSubGraphs, pipelineSubGraphsMap);
        Iterator<FlowNode> iterator = this.getOrderedTopologicalIterator();
        int ordinal = 0;
        int size = this.vertexSet().size();
        while (iterator.hasNext()) {
            BaseFlowNode next = (BaseFlowNode)iterator.next();
            next.setOrdinal(ordinal);
            next.setName(flowNodeFactory.makeFlowNodeName(next, size, ordinal));
            ++ordinal;
        }
    }

    protected void buildGraph(FlowNodeFactory flowNodeFactory, FlowElementGraph flowElementGraph, List<? extends ElementGraph> nodeSubGraphs, Map<ElementGraph, List<? extends ElementGraph>> pipelineSubGraphsMap) {
        if (pipelineSubGraphsMap == null) {
            pipelineSubGraphsMap = Collections.emptyMap();
        }
        for (ElementGraph elementGraph : nodeSubGraphs) {
            List<ElementGraph> pipelineGraphs = pipelineSubGraphsMap.get(elementGraph);
            FlowNode flowNode = flowNodeFactory.createFlowNode(flowElementGraph, elementGraph, pipelineGraphs);
            this.addVertex(flowNode);
        }
        this.bindEdges();
    }

    public Set<FlowElement> getFlowElementsFor(Enum annotation) {
        Set<FlowElement> results = Util.createIdentitySet();
        for (FlowNode flowNode : this.vertexSet()) {
            results.addAll(flowNode.getFlowElementsFor(annotation));
        }
        return results;
    }

    public Iterator<FlowNode> getOrderedTopologicalIterator() {
        return super.getOrderedTopologicalIterator(FLOW_NODE_COMPARATOR);
    }

    public static class FlowNodeComparator
    implements Comparator<FlowNode> {
        @Override
        public int compare(FlowNode lhs, FlowNode rhs) {
            int result;
            int rhsSize;
            int lhsSize = lhs.getElementGraph().vertexSet().size();
            int n = lhsSize < (rhsSize = rhs.getElementGraph().vertexSet().size()) ? -1 : (result = lhsSize == rhsSize ? 0 : 1);
            if (result != 0) {
                return result;
            }
            lhsSize = lhs.getSourceElements().size();
            return lhsSize < (rhsSize = rhs.getSourceElements().size()) ? -1 : (lhsSize == rhsSize ? 0 : 1);
        }
    }
}

