/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.process;

import cascading.flow.FlowElement;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.AnnotatedGraph;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.graph.Extent;
import cascading.flow.planner.process.ProcessEdge;
import cascading.flow.planner.process.ProcessGraph;
import cascading.flow.planner.process.ProcessModel;
import cascading.flow.planner.process.ProcessModels;
import cascading.pipe.Group;
import cascading.tap.Tap;
import cascading.util.EnumMultiMap;
import cascading.util.Util;
import cascading.util.jgrapht.IntegerNameProvider;
import cascading.util.jgrapht.VertexNameProvider;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseProcessGraph<Process extends ProcessModel>
implements ProcessGraph<Process> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseProcessGraph.class);
    final SimpleDirectedGraph<Process, ProcessEdge> graph;
    protected Set<FlowElement> sourceElements = Util.createIdentitySet();
    protected Set<FlowElement> sinkElements = Util.createIdentitySet();
    private Set<Tap> sourceTaps;
    private Set<Tap> sinkTaps;
    protected Map<String, Tap> trapsMap = new HashMap<String, Tap>();

    public BaseProcessGraph() {
        this.graph = new SimpleDirectedGraph(ProcessEdge.class);
    }

    @Override
    public boolean addVertex(Process process) {
        this.sourceElements.addAll(process.getSourceElements());
        this.sinkElements.addAll(process.getSinkElements());
        this.trapsMap.putAll(process.getTrapMap());
        return this.graph.addVertex(process);
    }

    public void bindEdges() {
        for (ProcessModel sinkProcess : this.vertexSet()) {
            for (ProcessModel sourceProcess : this.vertexSet()) {
                if (sourceProcess == sinkProcess) continue;
                this.sourceElements.removeAll(sinkProcess.getSinkElements());
                this.sinkElements.removeAll(sourceProcess.getSourceElements());
            }
        }
        for (ProcessModel sinkProcess : this.vertexSet()) {
            for (ProcessModel sourceProcess : this.vertexSet()) {
                if (sourceProcess == sinkProcess) continue;
                for (FlowElement intermediate : sourceProcess.getSinkElements()) {
                    if (!sinkProcess.getSourceElements().contains(intermediate)) continue;
                    this.addEdge(sourceProcess, sinkProcess, new ProcessEdge<ProcessModel>(sourceProcess, intermediate, sinkProcess));
                }
            }
        }
        this.sourceTaps = null;
        this.sinkTaps = null;
    }

    @Override
    public Set<FlowElement> getSourceElements() {
        return this.sourceElements;
    }

    @Override
    public Set<FlowElement> getSinkElements() {
        return this.sinkElements;
    }

    @Override
    public Set<Tap> getSourceTaps() {
        if (this.sourceTaps != null) {
            return this.sourceTaps;
        }
        this.sourceTaps = Util.narrowIdentitySet(Tap.class, this.getSourceElements());
        return this.sourceTaps;
    }

    @Override
    public Map<String, Tap> getSourceTapsMap() {
        HashMap<String, Tap> result = new HashMap<String, Tap>();
        Set<Tap> sourceTaps = this.getSourceTaps();
        for (Tap sourceTap : sourceTaps) {
            for (ProcessModel process : this.graph.vertexSet()) {
                if (!process.getSourceTaps().contains(sourceTap)) continue;
                ElementGraph elementGraph = process.getElementGraph();
                for (Scope scope : elementGraph.outgoingEdgesOf(sourceTap)) {
                    result.put(scope.getName(), sourceTap);
                }
            }
        }
        return result;
    }

    @Override
    public Set<Tap> getSinkTaps() {
        if (this.sinkTaps != null) {
            return this.sinkTaps;
        }
        this.sinkTaps = Util.narrowIdentitySet(Tap.class, this.getSinkElements());
        return this.sinkTaps;
    }

    @Override
    public Map<String, Tap> getSinkTapsMap() {
        HashMap<String, Tap> result = new HashMap<String, Tap>();
        Set<Tap> sinkTaps = this.getSinkTaps();
        for (Tap sinkTap : sinkTaps) {
            for (ProcessModel process : this.graph.vertexSet()) {
                if (!process.getSinkTaps().contains(sinkTap)) continue;
                ElementGraph elementGraph = process.getElementGraph();
                for (Scope scope : elementGraph.incomingEdgesOf(sinkTap)) {
                    result.put(scope.getName(), sinkTap);
                }
            }
        }
        return result;
    }

    @Override
    public Map<String, Tap> getTrapsMap() {
        return this.trapsMap;
    }

    @Override
    public Iterator<Process> getTopologicalIterator() {
        return this.getOrderedTopologicalIterator(new Comparator<Process>(){

            @Override
            public int compare(Process lhs, Process rhs) {
                return Integer.valueOf(lhs.getSubmitPriority()).compareTo(rhs.getSubmitPriority());
            }
        });
    }

    @Override
    public Iterator<Process> getOrdinalTopologicalIterator() {
        return this.getOrderedTopologicalIterator(new Comparator<Process>(){

            @Override
            public int compare(Process lhs, Process rhs) {
                return Integer.valueOf(lhs.getOrdinal()).compareTo(rhs.getOrdinal());
            }
        });
    }

    @Override
    public Iterator<Process> getOrderedTopologicalIterator(Comparator<Process> comparator) {
        return new TopologicalOrderIterator(this.graph, new PriorityQueue<Process>(10, comparator));
    }

    @Override
    public Set<ElementGraph> getElementGraphs() {
        Set<ElementGraph> results = Util.createIdentitySet();
        for (ProcessModel process : this.vertexSet()) {
            results.add(process.getElementGraph());
        }
        return results;
    }

    @Override
    public List<ElementGraph> getElementGraphs(FlowElement flowElement) {
        List<Process> elementProcesses = this.getElementProcesses(flowElement);
        ArrayList<ElementGraph> elementGraphs = new ArrayList<ElementGraph>();
        for (ProcessModel elementProcess : elementProcesses) {
            elementGraphs.add(elementProcess.getElementGraph());
        }
        return elementGraphs;
    }

    @Override
    public List<Process> getElementProcesses(FlowElement flowElement) {
        ArrayList<ProcessModel> processes = new ArrayList<ProcessModel>();
        for (ProcessModel process : this.vertexSet()) {
            if (!process.getElementGraph().vertexSet().contains(flowElement)) continue;
            processes.add(process);
        }
        return processes;
    }

    @Override
    public List<ElementGraph> getElementGraphs(Scope scope) {
        List<Process> elementProcesses = this.getElementProcesses(scope);
        ArrayList<ElementGraph> elementGraphs = new ArrayList<ElementGraph>();
        for (ProcessModel elementProcess : elementProcesses) {
            elementGraphs.add(elementProcess.getElementGraph());
        }
        return elementGraphs;
    }

    @Override
    public List<Process> getElementProcesses(Scope scope) {
        ArrayList<ProcessModel> processes = new ArrayList<ProcessModel>();
        for (ProcessModel process : this.vertexSet()) {
            if (!process.getElementGraph().edgeSet().contains(scope)) continue;
            processes.add(process);
        }
        return processes;
    }

    @Override
    public List<Process> getElementSourceProcesses(FlowElement flowElement) {
        ArrayList<ProcessModel> sources = new ArrayList<ProcessModel>();
        for (ProcessModel process : this.vertexSet()) {
            if (!process.getSinkElements().contains(flowElement)) continue;
            sources.add(process);
        }
        return sources;
    }

    @Override
    public List<Process> getElementSinkProcesses(FlowElement flowElement) {
        ArrayList<ProcessModel> sinks = new ArrayList<ProcessModel>();
        for (ProcessModel process : this.vertexSet()) {
            if (!process.getSourceElements().contains(flowElement)) continue;
            sinks.add(process);
        }
        return sinks;
    }

    @Override
    public Set<FlowElement> getAllSourceElements() {
        Set<FlowElement> results = Util.createIdentitySet();
        for (ProcessModel process : this.vertexSet()) {
            results.addAll(process.getSourceElements());
        }
        return results;
    }

    @Override
    public Set<FlowElement> getAllSinkElements() {
        Set<FlowElement> results = Util.createIdentitySet();
        for (ProcessModel process : this.vertexSet()) {
            results.addAll(process.getSinkElements());
        }
        return results;
    }

    @Override
    public EnumMultiMap<FlowElement> getAnnotations() {
        EnumMultiMap<FlowElement> annotations = new EnumMultiMap<FlowElement>();
        for (ProcessModel process : this.vertexSet()) {
            ElementGraph elementGraph = process.getElementGraph();
            if (!(elementGraph instanceof AnnotatedGraph)) continue;
            annotations.addAll(((AnnotatedGraph)((Object)elementGraph)).getAnnotations());
        }
        return annotations;
    }

    @Override
    public Set<FlowElement> getDuplicatedElements(ElementGraph elementGraph) {
        Set<FlowElement> results = Util.createIdentitySet();
        for (FlowElement flowElement : elementGraph.vertexSet()) {
            if (this.getElementProcesses(flowElement).size() <= 1) continue;
            results.add(flowElement);
        }
        results.remove(Extent.head);
        results.remove(Extent.tail);
        results.removeAll(this.getAllSourceElements());
        results.removeAll(this.getAllSinkElements());
        return results;
    }

    @Override
    public Set<ElementGraph> getIdentityElementGraphs() {
        Set<ElementGraph> results = Util.createIdentitySet();
        for (ProcessModel process : this.getIdentityProcesses()) {
            results.add(process.getElementGraph());
        }
        return results;
    }

    @Override
    public Set<Process> getIdentityProcesses() {
        HashSet<ProcessModel> results = new HashSet<ProcessModel>();
        for (ProcessModel process : this.vertexSet()) {
            if (!ProcessModels.isIdentity(process)) continue;
            results.add(process);
        }
        return results;
    }

    @Override
    public void writeDOT(String filename) {
        this.printProcessGraph(filename);
    }

    protected void printProcessGraph(String filename) {
        try {
            FileWriter writer = new FileWriter(filename);
            Util.writeDOT(writer, this.graph, new IntegerNameProvider(), new VertexNameProvider<Process>(){

                @Override
                public String getVertexName(Process process) {
                    String name = "[" + process.getName() + "]";
                    String sourceName = "";
                    Set<Tap> sources = process.getSourceTaps();
                    for (Tap tap : sources) {
                        sourceName = sourceName + "\\nsrc:[" + tap.getIdentifier() + "]";
                    }
                    if (sourceName.length() != 0) {
                        name = name + sourceName;
                    }
                    Collection<Group> groups = process.getGroups();
                    for (Group group : groups) {
                        String groupName = group.getName();
                        if (groupName.length() == 0) continue;
                        name = name + "\\ngrp:" + groupName;
                    }
                    Set<Tap> set = process.getSinkTaps();
                    String sinkName = "";
                    for (Tap sink : set) {
                        sinkName = "\\nsnk:[" + sink.getIdentifier() + "]";
                    }
                    if (sinkName.length() != 0) {
                        name = name + sinkName;
                    }
                    return name.replaceAll("\"", "'");
                }
            }, null);
            ((Writer)writer).close();
        }
        catch (IOException exception) {
            LOG.error("failed printing graph to: {}, with exception: {}", (Object)filename, (Object)exception);
        }
    }

    @Override
    public void writeDOTNested(String filename, ElementGraph graph) {
        ElementGraphs.printProcessGraph(filename, graph, this);
    }

    @Override
    public boolean containsEdge(Process sourceVertex, Process targetVertex) {
        return this.graph.containsEdge(sourceVertex, targetVertex);
    }

    @Override
    public boolean removeAllEdges(Collection<? extends ProcessEdge> edges) {
        return this.graph.removeAllEdges(edges);
    }

    @Override
    public Set<ProcessEdge> removeAllEdges(Process sourceVertex, Process targetVertex) {
        return this.graph.removeAllEdges(sourceVertex, targetVertex);
    }

    @Override
    public boolean removeAllVertices(Collection<? extends Process> vertices) {
        return this.graph.removeAllVertices(vertices);
    }

    @Override
    public Set<ProcessEdge> getAllEdges(Process sourceVertex, Process targetVertex) {
        return this.graph.getAllEdges(sourceVertex, targetVertex);
    }

    @Override
    public ProcessEdge getEdge(Process sourceVertex, Process targetVertex) {
        return (ProcessEdge)this.graph.getEdge(sourceVertex, targetVertex);
    }

    @Override
    public ProcessEdge addEdge(Process sourceVertex, Process targetVertex) {
        return (ProcessEdge)this.graph.addEdge(sourceVertex, targetVertex);
    }

    @Override
    public boolean addEdge(Process sourceVertex, Process targetVertex, ProcessEdge processEdge) {
        return this.graph.addEdge(sourceVertex, targetVertex, (Object)processEdge);
    }

    @Override
    public Process getEdgeSource(ProcessEdge processEdge) {
        return (Process)((ProcessModel)this.graph.getEdgeSource((Object)processEdge));
    }

    @Override
    public Process getEdgeTarget(ProcessEdge processEdge) {
        return (Process)((ProcessModel)this.graph.getEdgeTarget((Object)processEdge));
    }

    @Override
    public boolean containsEdge(ProcessEdge processEdge) {
        return this.graph.containsEdge((Object)processEdge);
    }

    @Override
    public boolean containsVertex(Process process) {
        return this.graph.containsVertex(process);
    }

    @Override
    public Set<ProcessEdge> edgeSet() {
        return this.graph.edgeSet();
    }

    @Override
    public Set<ProcessEdge> edgesOf(Process vertex) {
        return this.graph.edgesOf(vertex);
    }

    @Override
    public int inDegreeOf(Process vertex) {
        return this.graph.inDegreeOf(vertex);
    }

    @Override
    public Set<ProcessEdge> incomingEdgesOf(Process vertex) {
        return this.graph.incomingEdgesOf(vertex);
    }

    @Override
    public int outDegreeOf(Process vertex) {
        return this.graph.outDegreeOf(vertex);
    }

    @Override
    public Set<ProcessEdge> outgoingEdgesOf(Process vertex) {
        return this.graph.outgoingEdgesOf(vertex);
    }

    @Override
    public ProcessEdge removeEdge(Process sourceVertex, Process targetVertex) {
        return (ProcessEdge)this.graph.removeEdge(sourceVertex, targetVertex);
    }

    @Override
    public boolean removeEdge(ProcessEdge processEdge) {
        return this.graph.removeEdge((Object)processEdge);
    }

    @Override
    public boolean removeVertex(Process process) {
        return this.graph.removeVertex(process);
    }

    @Override
    public Set<Process> vertexSet() {
        return this.graph.vertexSet();
    }

    @Override
    public double getEdgeWeight(ProcessEdge processEdge) {
        return this.graph.getEdgeWeight((Object)processEdge);
    }
}

