/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.transformer;

import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementMultiGraph;
import cascading.flow.planner.iso.GraphResult;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.transformer.GraphTransformer;
import cascading.flow.planner.rule.Rule;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class Transformed<E extends ElementGraph>
extends GraphResult {
    PlannerContext plannerContext;
    GraphTransformer graphTransformer;
    ExpressionGraph expressionGraph;
    ElementGraph beginGraph;
    int recursionCount = 0;
    List<ElementGraph> recursions;
    List<Transformed> childTransforms;
    E endGraph;

    public Transformed(PlannerContext plannerContext, GraphTransformer graphTransformer, ElementGraph beginGraph) {
        this.plannerContext = plannerContext;
        this.graphTransformer = graphTransformer;
        if (plannerContext.isTransformTracingEnabled()) {
            beginGraph = new ElementMultiGraph(beginGraph);
        }
        this.beginGraph = beginGraph;
    }

    public Transformed(PlannerContext plannerContext, GraphTransformer graphTransformer, ExpressionGraph expressionGraph, ElementGraph beginGraph) {
        this.plannerContext = plannerContext;
        this.graphTransformer = graphTransformer;
        this.expressionGraph = expressionGraph;
        if (plannerContext.isTransformTracingEnabled()) {
            beginGraph = new ElementMultiGraph(beginGraph);
        }
        this.beginGraph = beginGraph;
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    @Override
    public String getRuleName() {
        if (this.getGraphTransform() instanceof Rule) {
            return ((Rule)((Object)this.getGraphTransform())).getRuleName();
        }
        return "none";
    }

    public String getTransformerName() {
        return this.getGraphTransform().getClass().getSimpleName();
    }

    public GraphTransformer getGraphTransform() {
        return this.graphTransformer;
    }

    @Override
    public ElementGraph getBeginGraph() {
        return this.beginGraph;
    }

    public void setEndGraph(E endGraph) {
        this.endGraph = endGraph;
    }

    public E getEndGraph() {
        return this.endGraph;
    }

    public int getNumRecursions() {
        return this.recursionCount;
    }

    public List<ElementGraph> getRecursions() {
        if (this.recursions == null) {
            this.recursions = new LinkedList<ElementGraph>();
        }
        return this.recursions;
    }

    public List<Transformed> getChildTransforms() {
        if (this.childTransforms == null) {
            this.childTransforms = new LinkedList<Transformed>();
        }
        return this.childTransforms;
    }

    void addRecursionTransform(ElementGraph transformed) {
        ++this.recursionCount;
        if (this.plannerContext.isTransformTracingEnabled()) {
            this.getRecursions().add(new ElementMultiGraph(transformed));
        }
    }

    public void addChildTransform(Transformed transformed) {
        if (this.plannerContext.isTransformTracingEnabled()) {
            this.getChildTransforms().add(transformed);
        }
    }

    @Override
    public void writeDOTs(String path) {
        String name;
        int count = 0;
        if (this.expressionGraph != null) {
            String fileName = String.format("expression-graph-%s.dot", this.expressionGraph.getClass().getSimpleName());
            this.expressionGraph.writeDOT(new File(path, fileName).toString());
        }
        for (int i = 0; i < this.getChildTransforms().size(); ++i) {
            Transformed transformed = this.getChildTransforms().get(i);
            name = transformed.getTransformerName();
            String pathName = String.format("%s/child-%d-%s/", path, i, name);
            transformed.writeDOTs(pathName);
        }
        count = this.writeBeginGraph(path, count);
        for (ElementGraph recursion : this.getRecursions()) {
            name = recursion.getClass().getSimpleName();
            recursion.writeDOT(new File(path, this.makeFileName(count++, name, "recursion")).toString());
        }
        this.writeEndGraph(path, count);
    }
}

