/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.transformer;

import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.graph.ElementSubGraph;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.finder.GraphFinder;
import cascading.flow.planner.iso.finder.Match;
import cascading.flow.planner.iso.transformer.GraphTransformer;
import cascading.flow.planner.iso.transformer.Transformed;
import cascading.flow.planner.rule.TransformException;

public class SubGraphTransformer
extends GraphTransformer<ElementGraph, ElementSubGraph> {
    private GraphTransformer graphTransformer;
    private ExpressionGraph subGraphMatcher;
    private GraphFinder subGraphFinder;
    private boolean findAllPrimaries = false;

    public SubGraphTransformer(GraphTransformer graphTransformer, ExpressionGraph subGraphMatcher) {
        this.graphTransformer = graphTransformer;
        this.subGraphMatcher = subGraphMatcher;
        this.subGraphFinder = new GraphFinder(subGraphMatcher);
        this.findAllPrimaries = subGraphMatcher.supportsNonRecursiveMatch();
    }

    @Override
    public Transformed<ElementSubGraph> transform(PlannerContext plannerContext, ElementGraph rootGraph) {
        Transformed<ElementSubGraph> transformed = new Transformed<ElementSubGraph>(plannerContext, this, this.subGraphMatcher, rootGraph);
        try {
            Match match;
            Transformed contractedTransformed = this.graphTransformer.transform(plannerContext, rootGraph);
            transformed.addChildTransform(contractedTransformed);
            Object contractedGraph = contractedTransformed.getEndGraph();
            Match match2 = match = this.findAllPrimaries ? this.subGraphFinder.findAllMatches(plannerContext, (ElementGraph)contractedGraph) : this.subGraphFinder.findFirstMatch(plannerContext, (ElementGraph)contractedGraph);
            if (!match.foundMatch()) {
                return transformed;
            }
            ElementSubGraph contractedSubGraph = match.getMatchedGraph();
            ElementSubGraph resultSubGraph = this.asSubGraphOf(rootGraph, contractedSubGraph);
            transformed.setEndGraph(resultSubGraph);
            return transformed;
        }
        catch (Throwable throwable) {
            throw new TransformException(throwable, transformed);
        }
    }

    protected ElementSubGraph asSubGraphOf(ElementGraph rootGraph, ElementGraph contractedSubGraph) {
        return ElementGraphs.asSubGraph(rootGraph, contractedSubGraph, null);
    }
}

