/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.transformer;

import cascading.flow.FlowElement;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.finder.Match;
import cascading.flow.planner.iso.transformer.ElementFactory;
import cascading.flow.planner.iso.transformer.GraphTransformer;
import cascading.flow.planner.iso.transformer.MutateGraphTransformer;
import cascading.flow.planner.iso.transformer.Transformed;
import java.util.Set;

public class ReplaceGraphFactoryBasedTransformer
extends MutateGraphTransformer {
    private final String factoryName;

    public ReplaceGraphFactoryBasedTransformer(ExpressionGraph filter, String factoryName) {
        super(null, filter);
        this.factoryName = factoryName;
        if (factoryName == null) {
            throw new IllegalArgumentException("factoryName may not be null");
        }
    }

    public ReplaceGraphFactoryBasedTransformer(GraphTransformer graphTransformer, ExpressionGraph filter, String factoryName) {
        super(graphTransformer, filter);
        this.factoryName = factoryName;
        if (factoryName == null) {
            throw new IllegalArgumentException("factoryName may not be null");
        }
    }

    @Override
    protected boolean transformGraphInPlaceUsing(Transformed<ElementGraph> transformed, ElementGraph graph, Match match) {
        ElementFactory elementFactory = transformed.getPlannerContext().getElementFactoryFor(this.factoryName);
        if (elementFactory == null) {
            return false;
        }
        Set<FlowElement> captured = match.getCapturedElements(ElementCapture.Primary);
        if (captured.isEmpty()) {
            return false;
        }
        if (captured.size() != 1) {
            throw new IllegalStateException("expected one, but found multiple flow elements in the match expression: " + captured);
        }
        FlowElement replace = captured.iterator().next();
        FlowElement replaceWith = elementFactory.create(graph, replace);
        ElementGraphs.replaceElementWith(graph, replace, replaceWith);
        return true;
    }
}

