/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.transformer;

import cascading.flow.FlowElement;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.finder.Match;
import cascading.flow.planner.iso.transformer.GraphTransformer;
import cascading.flow.planner.iso.transformer.MutateGraphTransformer;
import cascading.flow.planner.iso.transformer.Transformed;
import cascading.util.Util;
import java.util.Set;

public class RemoveBranchGraphTransformer
extends MutateGraphTransformer {
    public RemoveBranchGraphTransformer(ExpressionGraph filter) {
        super(filter);
    }

    public RemoveBranchGraphTransformer(GraphTransformer graphTransformer, ExpressionGraph filter) {
        super(graphTransformer, filter);
    }

    @Override
    protected boolean transformGraphInPlaceUsing(Transformed<ElementGraph> transformed, ElementGraph graph, Match match) {
        Set<FlowElement> primary = match.getCapturedElements(ElementCapture.Primary);
        Set<FlowElement> secondary = match.getCapturedElements(ElementCapture.Secondary);
        if (primary.isEmpty()) {
            return false;
        }
        if (secondary.isEmpty()) {
            for (FlowElement flowElement : primary) {
                boolean found = ElementGraphs.removeBranchContaining(graph, flowElement);
                if (found) continue;
                throw new IllegalStateException("no branch found at: " + flowElement);
            }
        } else {
            if (secondary.size() != 1) {
                throw new IllegalStateException("too many captured secondary elements");
            }
            boolean found = ElementGraphs.removeBranchBetween(graph, Util.getFirst(primary), Util.getFirst(secondary), false);
            if (!found) {
                throw new IllegalStateException("no branch found between: " + Util.getFirst(primary) + " and " + Util.getFirst(secondary));
            }
        }
        return true;
    }
}

