/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.transformer;

import cascading.flow.FlowElement;
import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.finder.GraphFinder;
import cascading.flow.planner.iso.finder.Match;
import cascading.flow.planner.iso.transformer.GraphTransformer;
import cascading.flow.planner.iso.transformer.Transformed;
import cascading.flow.planner.rule.TransformException;
import cascading.util.ProcessLogger;
import java.util.Collections;
import java.util.Set;

public abstract class RecursiveGraphTransformer<E extends ElementGraph>
extends GraphTransformer<E, E> {
    public static final String TRANSFORM_RECURSION_DEPTH_MAX = "cascading.planner.transformer.recursion.depth.max";
    public static final int DEFAULT_TRANSFORM_RECURSION_DEPTH_MAX = 1000;
    private final GraphFinder finder;
    private final ExpressionGraph expressionGraph;
    private final boolean findAllPrimaries;

    protected RecursiveGraphTransformer(ExpressionGraph expressionGraph) {
        this.expressionGraph = expressionGraph;
        this.finder = new GraphFinder(expressionGraph);
        this.findAllPrimaries = expressionGraph.supportsNonRecursiveMatch();
    }

    @Override
    public Transformed<E> transform(PlannerContext plannerContext, E rootGraph) {
        int maxDepth = plannerContext.getIntProperty(TRANSFORM_RECURSION_DEPTH_MAX, 1000);
        Transformed transformed = new Transformed(plannerContext, this, this.expressionGraph, (ElementGraph)rootGraph);
        Object result = this.transform(plannerContext.getLogger(), transformed, rootGraph, maxDepth, 0);
        transformed.setEndGraph(result);
        return transformed;
    }

    protected E transform(ProcessLogger processLogger, Transformed<E> transformed, E graph, int maxDepth, int currentDepth) {
        if (currentDepth == maxDepth) {
            processLogger.logInfo("!!! transform recursion ending, reached depth: {}", currentDepth);
            return graph;
        }
        if (processLogger.isDebugEnabled()) {
            processLogger.logDebug("preparing match within: {}", this.getClass().getSimpleName());
        }
        ElementGraph prepared = this.prepareForMatch(processLogger, transformed, graph);
        if (processLogger.isDebugEnabled()) {
            processLogger.logDebug("completed match within: {}, with result: {}", this.getClass().getSimpleName(), prepared != null);
        }
        if (prepared == null) {
            return graph;
        }
        Set<FlowElement> exclusions = this.addExclusions(graph);
        if (processLogger.isDebugEnabled()) {
            processLogger.logDebug("performing match within: {}, using recursion: {}", this.getClass().getSimpleName(), !this.findAllPrimaries);
        }
        Match match = this.findAllPrimaries ? this.finder.findAllMatches(transformed.getPlannerContext(), prepared, exclusions) : this.finder.findFirstMatch(transformed.getPlannerContext(), prepared, exclusions);
        if (processLogger.isDebugEnabled()) {
            processLogger.logDebug("completed match within: {}", this.getClass().getSimpleName());
        }
        if (processLogger.isDebugEnabled()) {
            processLogger.logDebug("performing transform in place within: {}", this.getClass().getSimpleName());
        }
        boolean transformResult = this.transformGraphInPlaceUsingSafe(transformed, graph, match);
        if (processLogger.isDebugEnabled()) {
            processLogger.logDebug("completed transform in place within: {}, with result: {}", this.getClass().getSimpleName(), transformResult);
        }
        if (!transformResult) {
            return graph;
        }
        transformed.addRecursionTransform((ElementGraph)graph);
        if (!this.requiresRecursiveSearch()) {
            return graph;
        }
        return this.transform(processLogger, transformed, graph, maxDepth, ++currentDepth);
    }

    private boolean transformGraphInPlaceUsingSafe(Transformed<E> transformed, E graph, Match match) {
        try {
            return this.transformGraphInPlaceUsing(transformed, graph, match);
        }
        catch (TransformException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new TransformException(throwable, transformed);
        }
    }

    protected boolean requiresRecursiveSearch() {
        return !this.findAllPrimaries;
    }

    protected Set<FlowElement> addExclusions(E graph) {
        return Collections.emptySet();
    }

    protected ElementGraph prepareForMatch(ProcessLogger processLogger, Transformed<E> transformed, E graph) {
        return graph;
    }

    protected abstract boolean transformGraphInPlaceUsing(Transformed<E> var1, E var2, Match var3);
}

