/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.transformer;

import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.transformer.GraphTransformer;
import cascading.flow.planner.iso.transformer.RecursiveGraphTransformer;
import cascading.flow.planner.iso.transformer.Transformed;
import cascading.util.ProcessLogger;

public abstract class MutateGraphTransformer
extends RecursiveGraphTransformer<ElementGraph> {
    protected final GraphTransformer graphTransformer;

    public MutateGraphTransformer(ExpressionGraph filter) {
        super(filter);
        this.graphTransformer = null;
    }

    public MutateGraphTransformer(GraphTransformer graphTransformer, ExpressionGraph filter) {
        super(filter);
        this.graphTransformer = graphTransformer;
    }

    @Override
    protected boolean requiresRecursiveSearch() {
        return this.graphTransformer != null || super.requiresRecursiveSearch();
    }

    @Override
    protected ElementGraph prepareForMatch(ProcessLogger processLogger, Transformed<ElementGraph> transformed, ElementGraph graph) {
        if (this.graphTransformer == null) {
            return graph;
        }
        if (processLogger.isDebugEnabled()) {
            processLogger.logDebug("transforming with: {}", this.graphTransformer.getClass().getSimpleName());
        }
        Transformed child = this.graphTransformer.transform(transformed.getPlannerContext(), graph);
        transformed.addChildTransform(child);
        return child.getEndGraph();
    }
}

