/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.transformer;

import cascading.flow.FlowElement;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.finder.Match;
import cascading.flow.planner.iso.transformer.ElementFactory;
import cascading.flow.planner.iso.transformer.GraphTransformer;
import cascading.flow.planner.iso.transformer.MutateGraphTransformer;
import cascading.flow.planner.iso.transformer.Transformed;
import java.util.HashSet;
import java.util.Set;

public class InsertionGraphTransformer
extends MutateGraphTransformer {
    private Insertion insertion = Insertion.After;
    private final String factoryName;
    private ElementCapture capture = ElementCapture.Primary;

    public InsertionGraphTransformer(ExpressionGraph expressionGraph, String factoryName) {
        this(expressionGraph, ElementCapture.Primary, factoryName);
    }

    public InsertionGraphTransformer(ExpressionGraph expressionGraph, String factoryName, Insertion insertion) {
        this(expressionGraph, ElementCapture.Primary, factoryName, insertion);
    }

    public InsertionGraphTransformer(ExpressionGraph expressionGraph, ElementCapture capture, String factoryName) {
        this(expressionGraph, capture, factoryName, Insertion.After);
    }

    public InsertionGraphTransformer(ExpressionGraph expressionGraph, ElementCapture capture, String factoryName, Insertion insertion) {
        super(expressionGraph);
        this.insertion = insertion;
        if (capture != null) {
            this.capture = capture;
        }
        this.factoryName = factoryName;
        if (factoryName == null) {
            throw new IllegalArgumentException("factoryName may not be null");
        }
    }

    public InsertionGraphTransformer(GraphTransformer graphTransformer, ExpressionGraph filter, String factoryName) {
        this(graphTransformer, filter, ElementCapture.Primary, factoryName);
    }

    public InsertionGraphTransformer(GraphTransformer graphTransformer, ExpressionGraph filter, ElementCapture capture, String factoryName) {
        this(graphTransformer, filter, capture, factoryName, Insertion.After);
    }

    public InsertionGraphTransformer(GraphTransformer graphTransformer, ExpressionGraph filter, ElementCapture capture, String factoryName, Insertion insertion) {
        super(graphTransformer, filter);
        this.insertion = insertion;
        if (capture != null) {
            this.capture = capture;
        }
        this.factoryName = factoryName;
        if (factoryName == null) {
            throw new IllegalArgumentException("factoryName may not be null");
        }
    }

    @Override
    protected boolean transformGraphInPlaceUsing(Transformed<ElementGraph> transformed, ElementGraph graph, Match match) {
        Set<FlowElement> insertions = match.getCapturedElements(this.capture);
        if (insertions.isEmpty()) {
            return false;
        }
        ElementFactory elementFactory = transformed.getPlannerContext().getElementFactoryFor(this.factoryName);
        block6: for (FlowElement flowElement : insertions) {
            switch (this.insertion) {
                case Before: {
                    ElementGraphs.insertFlowElementBefore(graph, flowElement, elementFactory.create(graph, flowElement));
                    break;
                }
                case After: {
                    ElementGraphs.insertFlowElementAfter(graph, flowElement, elementFactory.create(graph, flowElement));
                    break;
                }
                case BeforeEachEdge: {
                    HashSet<Scope> incomingEdges = new HashSet<Scope>(graph.incomingEdgesOf(flowElement));
                    for (Scope incomingEdge : incomingEdges) {
                        FlowElement predecessor = graph.getEdgeSource(incomingEdge);
                        ElementGraphs.insertFlowElementBetweenEdge(graph, incomingEdge, elementFactory.create(graph, predecessor));
                    }
                    continue block6;
                }
                case AfterEachEdge: {
                    HashSet<Scope> outgoingEdges = new HashSet<Scope>(graph.outgoingEdgesOf(flowElement));
                    for (Scope outgoingEdge : outgoingEdges) {
                        FlowElement successor = graph.getEdgeTarget(outgoingEdge);
                        ElementGraphs.insertFlowElementBetweenEdge(graph, outgoingEdge, elementFactory.create(graph, successor));
                    }
                    break;
                }
            }
        }
        return true;
    }

    public static enum Insertion {
        Before,
        After,
        BeforeEachEdge,
        AfterEachEdge;

    }
}

