/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.transformer;

import cascading.flow.FlowElement;
import cascading.flow.planner.graph.AnnotatedGraph;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementMultiGraph;
import cascading.flow.planner.iso.ElementAnnotation;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.finder.Match;
import cascading.flow.planner.iso.transformer.GraphTransformer;
import cascading.flow.planner.iso.transformer.RecursiveGraphTransformer;
import cascading.flow.planner.iso.transformer.Transformed;
import cascading.util.ProcessLogger;
import java.util.Collection;
import java.util.Set;

public class AnnotateGraphTransformer
extends RecursiveGraphTransformer<ElementGraph> {
    private final ElementAnnotation annotation;
    protected final GraphTransformer graphTransformer;

    public AnnotateGraphTransformer(ExpressionGraph match, ElementAnnotation annotation) {
        super(match);
        this.annotation = annotation;
        this.graphTransformer = null;
    }

    public AnnotateGraphTransformer(GraphTransformer graphTransformer, ExpressionGraph match, ElementAnnotation annotation) {
        super(match);
        this.annotation = annotation;
        this.graphTransformer = graphTransformer;
    }

    @Override
    protected boolean requiresRecursiveSearch() {
        return this.graphTransformer != null || super.requiresRecursiveSearch();
    }

    @Override
    protected ElementGraph prepareForMatch(ProcessLogger processLogger, Transformed<ElementGraph> transformed, ElementGraph graph) {
        if (this.graphTransformer == null) {
            return this.makeAnnotated(graph);
        }
        Transformed child = this.graphTransformer.transform(transformed.getPlannerContext(), graph);
        transformed.addChildTransform(child);
        Object endGraph = child.getEndGraph();
        return this.makeAnnotated((ElementGraph)endGraph);
    }

    private ElementGraph makeAnnotated(ElementGraph endGraph) {
        if (endGraph == null) {
            return null;
        }
        if (endGraph instanceof AnnotatedGraph) {
            return endGraph;
        }
        return new ElementMultiGraph(endGraph);
    }

    @Override
    protected Set<FlowElement> addExclusions(ElementGraph graph) {
        return (Set)((AnnotatedGraph)((Object)graph)).getAnnotations().getValues(this.annotation.getAnnotation());
    }

    @Override
    protected boolean transformGraphInPlaceUsing(Transformed<ElementGraph> transformed, ElementGraph graph, Match match) {
        Set<FlowElement> captured = match.getCapturedElements(this.annotation.getCapture());
        if (captured.isEmpty()) {
            return false;
        }
        ((AnnotatedGraph)((Object)graph)).getAnnotations().addAll(this.annotation.getAnnotation(), (Collection<FlowElement>)captured);
        return true;
    }
}

