/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.subgraph.partitioner;

import cascading.flow.FlowElement;
import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.ElementAnnotation;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.subgraph.GraphPartitioner;
import cascading.flow.planner.iso.subgraph.Partitions;
import cascading.flow.planner.iso.subgraph.SubGraphIterator;
import cascading.flow.planner.iso.subgraph.iterator.ExpressionSubGraphIterator;
import cascading.util.EnumMultiMap;
import java.util.Collection;
import java.util.LinkedHashMap;

public class ExpressionGraphPartitioner
extends GraphPartitioner {
    protected ExpressionGraph contractionGraph;
    protected ExpressionGraph expressionGraph;
    protected ElementAnnotation[] annotations = new ElementAnnotation[0];

    public ExpressionGraphPartitioner(ExpressionGraph contractionGraph, ExpressionGraph expressionGraph, ElementAnnotation ... annotations) {
        this.contractionGraph = contractionGraph;
        this.expressionGraph = expressionGraph;
        this.annotations = annotations;
    }

    public ExpressionGraph getContractionGraph() {
        return this.contractionGraph;
    }

    public ExpressionGraph getExpressionGraph() {
        return this.expressionGraph;
    }

    public ElementAnnotation[] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(ElementAnnotation[] annotations) {
        this.annotations = annotations;
    }

    @Override
    public Partitions partition(PlannerContext plannerContext, ElementGraph elementGraph, Collection<FlowElement> excludes) {
        LinkedHashMap<ElementGraph, EnumMultiMap> annotatedSubGraphs = new LinkedHashMap<ElementGraph, EnumMultiMap>();
        ExpressionSubGraphIterator expressionIterator = new ExpressionSubGraphIterator(plannerContext, this.contractionGraph, this.expressionGraph, elementGraph, excludes);
        SubGraphIterator stepIterator = this.wrapIterator(expressionIterator);
        while (stepIterator.hasNext()) {
            ElementGraph next = (ElementGraph)stepIterator.next();
            EnumMultiMap annotationMap = stepIterator.getAnnotationMap(this.annotations);
            annotatedSubGraphs.put(next, annotationMap);
        }
        return new Partitions(this, elementGraph, expressionIterator.getContractedGraph(), expressionIterator.getMatches(), annotatedSubGraphs);
    }

    protected SubGraphIterator wrapIterator(ExpressionSubGraphIterator expressionIterator) {
        return expressionIterator;
    }
}

