/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.subgraph.iterator;

import cascading.flow.FlowElement;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.graph.ElementSubGraph;
import cascading.flow.planner.iso.ElementAnnotation;
import cascading.flow.planner.iso.subgraph.SubGraphIterator;
import cascading.util.EnumMultiMap;
import cascading.util.Pair;
import cascading.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jgrapht.GraphPath;

public class UniquePathSubGraphIterator
implements SubGraphIterator {
    SubGraphIterator subGraphIterator;
    boolean longestFirst;
    boolean multiEdge;
    ElementGraph current = null;
    Iterator<GraphPath<FlowElement, Scope>> pathsIterator;
    Set<Pair<FlowElement, FlowElement>> pairs = new HashSet<Pair<FlowElement, FlowElement>>();

    public UniquePathSubGraphIterator(SubGraphIterator subGraphIterator, boolean longestFirst, boolean multiEdge) {
        this.subGraphIterator = subGraphIterator;
        this.longestFirst = longestFirst;
        this.multiEdge = multiEdge;
    }

    public Set<Pair<FlowElement, FlowElement>> getPairs() {
        return this.pairs;
    }

    @Override
    public ElementGraph getElementGraph() {
        return this.subGraphIterator.getElementGraph();
    }

    @Override
    public EnumMultiMap getAnnotationMap(ElementAnnotation[] annotations) {
        return this.subGraphIterator.getAnnotationMap(annotations);
    }

    @Override
    public boolean hasNext() {
        if (this.pathsIterator == null) {
            this.advance();
        }
        if (this.current == null || this.pathsIterator == null) {
            return false;
        }
        boolean hasNextPath = this.pathsIterator.hasNext();
        if (hasNextPath) {
            return true;
        }
        return this.subGraphIterator.hasNext();
    }

    private void advance() {
        if (this.current == null) {
            if (!this.subGraphIterator.hasNext()) {
                return;
            }
            this.current = (ElementGraph)this.subGraphIterator.next();
            this.pathsIterator = null;
        }
        if (this.pathsIterator == null) {
            Set<FlowElement> sources = ElementGraphs.findSources(this.current, FlowElement.class);
            Set<FlowElement> sinks = ElementGraphs.findSinks(this.current, FlowElement.class);
            if (sources.size() > 1 || sinks.size() > 1) {
                throw new IllegalArgumentException("only supports single source and single sink graphs");
            }
            FlowElement source = Util.getFirst(sources);
            FlowElement sink = Util.getFirst(sinks);
            this.pairs.add(new Pair<FlowElement, FlowElement>(source, sink));
            List<GraphPath<FlowElement, Scope>> paths = ElementGraphs.getAllShortestPathsBetween(this.current, source, sink);
            if (this.longestFirst) {
                Collections.reverse(paths);
            }
            this.pathsIterator = paths.iterator();
        }
    }

    @Override
    public ElementGraph next() {
        if (!this.pathsIterator.hasNext()) {
            this.current = null;
            this.pathsIterator = null;
            this.advance();
            return this.next();
        }
        GraphPath<FlowElement, Scope> path = this.pathsIterator.next();
        List vertexList = path.getVertexList();
        Collection<Object> edgeList = path.getEdgeList();
        if (this.multiEdge) {
            edgeList = ElementGraphs.getAllMultiEdgesBetween(edgeList, this.current);
        }
        return new ElementSubGraph(this.current, vertexList, edgeList);
    }

    @Override
    public void remove() {
        this.subGraphIterator.remove();
    }
}

