/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.subgraph.iterator;

import cascading.flow.FlowElement;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.graph.ElementMaskSubGraph;
import cascading.flow.planner.graph.Extent;
import cascading.flow.planner.iso.ElementAnnotation;
import cascading.flow.planner.iso.subgraph.SubGraphIterator;
import cascading.flow.planner.iso.subgraph.iterator.UniquePathSubGraphIterator;
import cascading.util.EnumMultiMap;
import cascading.util.Pair;
import cascading.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.GraphPath;

public class IncludeRemainderSubGraphIterator
implements SubGraphIterator {
    SubGraphIterator parentIterator;
    boolean multiEdge;
    Set<FlowElement> maskedElements = Util.createIdentitySet();
    Set<Scope> maskedScopes = new HashSet<Scope>();

    public IncludeRemainderSubGraphIterator(SubGraphIterator parentIterator, boolean multiEdge) {
        this.maskedElements.add(Extent.head);
        this.maskedElements.add(Extent.tail);
        this.parentIterator = parentIterator;
        this.multiEdge = multiEdge;
    }

    @Override
    public ElementGraph getElementGraph() {
        return this.parentIterator.getElementGraph();
    }

    @Override
    public EnumMultiMap getAnnotationMap(ElementAnnotation[] annotations) {
        return this.parentIterator.getAnnotationMap(annotations);
    }

    @Override
    public boolean hasNext() {
        return this.parentIterator.hasNext();
    }

    @Override
    public ElementGraph next() {
        ElementGraph next = (ElementGraph)this.parentIterator.next();
        if (this.parentIterator.hasNext()) {
            this.maskedElements.addAll(next.vertexSet());
            this.maskedScopes.addAll(next.edgeSet());
            return next;
        }
        ElementGraph elementGraph = this.parentIterator.getElementGraph();
        if (!this.multiEdge) {
            this.maskedElements.removeAll(next.vertexSet());
            this.maskedScopes.removeAll(next.edgeSet());
        } else {
            this.maskedElements.addAll(next.vertexSet());
            this.maskedScopes.addAll(next.edgeSet());
            for (FlowElement maskedElement : new ArrayList<FlowElement>(this.maskedElements)) {
                if (this.maskedScopes.containsAll(elementGraph.edgesOf(maskedElement))) continue;
                this.maskedElements.remove(maskedElement);
            }
        }
        Set<Pair<FlowElement, FlowElement>> pairs = this.getPairs();
        ElementMaskSubGraph maskSubGraph = new ElementMaskSubGraph(elementGraph, this.maskedElements, this.maskedScopes);
        Set<FlowElement> sources = ElementGraphs.findSources(maskSubGraph, FlowElement.class);
        Set<FlowElement> sinks = ElementGraphs.findSinks(maskSubGraph, FlowElement.class);
        for (FlowElement source : sources) {
            for (FlowElement sink : sinks) {
                if (pairs.contains(new Pair<FlowElement, FlowElement>(source, sink))) continue;
                List<GraphPath<FlowElement, Scope>> paths = ElementGraphs.getAllShortestPathsBetween(elementGraph, source, sink);
                for (GraphPath<FlowElement, Scope> path : paths) {
                    this.maskedElements.removeAll(path.getVertexList());
                    Collection<Object> edgeList = path.getEdgeList();
                    if (this.multiEdge) {
                        edgeList = ElementGraphs.getAllMultiEdgesBetween(edgeList, elementGraph);
                    }
                    this.maskedScopes.removeAll(edgeList);
                }
            }
        }
        return new ElementMaskSubGraph(elementGraph, this.maskedElements, this.maskedScopes);
    }

    protected Set<Pair<FlowElement, FlowElement>> getPairs() {
        Set<Pair<FlowElement, FlowElement>> pairs = Collections.emptySet();
        if (this.parentIterator instanceof UniquePathSubGraphIterator) {
            pairs = ((UniquePathSubGraphIterator)this.parentIterator).getPairs();
        }
        return pairs;
    }

    @Override
    public void remove() {
        this.parentIterator.remove();
    }
}

