/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.subgraph.iterator;

import cascading.flow.FlowElement;
import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.graph.ElementSubGraph;
import cascading.flow.planner.iso.ElementAnnotation;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.finder.GraphFinder;
import cascading.flow.planner.iso.finder.Match;
import cascading.flow.planner.iso.subgraph.SubGraphIterator;
import cascading.flow.planner.iso.transformer.ContractedTransformer;
import cascading.flow.planner.iso.transformer.Transformed;
import cascading.util.EnumMultiMap;
import cascading.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class ExpressionSubGraphIterator
implements SubGraphIterator {
    private final PlannerContext plannerContext;
    private final ElementGraph elementGraph;
    private ContractedTransformer contractedTransformer;
    private GraphFinder graphFinder;
    private Set<FlowElement> elementExcludes = Util.createIdentitySet();
    private ElementGraph contractedGraph;
    private Transformed<ElementGraph> contractedTransformed;
    private boolean firstOnly = false;
    private Match match;
    private List<Match> matches = new ArrayList<Match>();
    int count = 0;

    public ExpressionSubGraphIterator(ExpressionGraph matchExpression, ElementGraph elementGraph) {
        this(new PlannerContext(), matchExpression, elementGraph);
    }

    public ExpressionSubGraphIterator(PlannerContext plannerContext, ExpressionGraph matchExpression, ElementGraph elementGraph) {
        this(plannerContext, null, matchExpression, elementGraph);
    }

    public ExpressionSubGraphIterator(PlannerContext plannerContext, ExpressionGraph contractionExpression, ExpressionGraph matchExpression, ElementGraph elementGraph) {
        this(plannerContext, contractionExpression, matchExpression, false, elementGraph);
    }

    public ExpressionSubGraphIterator(PlannerContext plannerContext, ExpressionGraph contractionExpression, ExpressionGraph matchExpression, ElementGraph elementGraph, Collection<FlowElement> elementExcludes) {
        this(plannerContext, contractionExpression, matchExpression, false, elementGraph, elementExcludes);
    }

    public ExpressionSubGraphIterator(PlannerContext plannerContext, ExpressionGraph contractionExpression, ExpressionGraph matchExpression, boolean firstOnly, ElementGraph elementGraph) {
        this(plannerContext, contractionExpression, matchExpression, firstOnly, elementGraph, null);
    }

    public ExpressionSubGraphIterator(PlannerContext plannerContext, ExpressionGraph contractionExpression, ExpressionGraph matchExpression, boolean firstOnly, ElementGraph elementGraph, Collection<FlowElement> elementExcludes) {
        this.plannerContext = plannerContext;
        this.firstOnly = firstOnly;
        this.elementGraph = elementGraph;
        if (elementExcludes != null) {
            this.elementExcludes.addAll(elementExcludes);
        }
        if (contractionExpression != null) {
            this.contractedTransformer = new ContractedTransformer(contractionExpression);
        } else {
            this.contractedGraph = elementGraph;
        }
        this.graphFinder = new GraphFinder(matchExpression);
    }

    @Override
    public ElementGraph getElementGraph() {
        return this.elementGraph;
    }

    public List<Match> getMatches() {
        return this.matches;
    }

    public ElementGraph getContractedGraph() {
        if (this.contractedGraph == null) {
            this.contractedTransformed = this.contractedTransformer.transform(this.plannerContext, this.elementGraph);
            this.contractedGraph = this.contractedTransformed.getEndGraph();
        }
        return this.contractedGraph;
    }

    public Match getLastMatch() {
        if (this.matches.isEmpty()) {
            return null;
        }
        return this.matches.get(this.count - 1);
    }

    @Override
    public EnumMultiMap getAnnotationMap(ElementAnnotation[] annotations) {
        EnumMultiMap<FlowElement> annotationsMap = new EnumMultiMap<FlowElement>();
        if (annotations.length == 0) {
            return annotationsMap;
        }
        Match match = this.getLastMatch();
        for (ElementAnnotation annotation : annotations) {
            annotationsMap.addAll(annotation.getAnnotation(), (Collection<FlowElement>)match.getCapturedElements(annotation.getCapture()));
        }
        return annotationsMap;
    }

    @Override
    public boolean hasNext() {
        if (this.match == null) {
            this.match = this.graphFinder.findMatchesOnPrimary(this.plannerContext, this.getContractedGraph(), this.firstOnly, this.elementExcludes);
            if (this.match.foundMatch()) {
                this.matches.add(this.match);
                this.elementExcludes.addAll(this.match.getCapturedElements(ElementCapture.Primary));
                ++this.count;
            }
        }
        return this.match.foundMatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementGraph next() {
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ElementSubGraph contractedMatchedGraph = this.match.getMatchedGraph();
            Set<FlowElement> excludes = this.getContractedGraph().vertexSetCopy();
            excludes.removeAll(contractedMatchedGraph.vertexSet());
            ElementSubGraph elementSubGraph = ElementGraphs.asSubGraph(this.elementGraph, contractedMatchedGraph, excludes);
            return elementSubGraph;
        }
        finally {
            this.match = null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

