/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.subgraph;

import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementMultiGraph;
import cascading.flow.planner.iso.GraphResult;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.finder.Match;
import cascading.flow.planner.iso.subgraph.GraphPartitioner;
import cascading.flow.planner.iso.subgraph.partitioner.ExpressionGraphPartitioner;
import cascading.flow.planner.rule.RulePartitioner;
import cascading.util.EnumMultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Partitions
extends GraphResult {
    private RulePartitioner rulePartitioner;
    private final GraphPartitioner graphPartitioner;
    private final ElementGraph beginGraph;
    private final Map<ElementGraph, EnumMultiMap> annotatedSubGraphs;
    private ElementGraph contractedGraph;
    private List<Match> contractedMatches = Collections.emptyList();

    public Partitions(GraphPartitioner graphPartitioner, ElementGraph beginGraph, Map<ElementGraph, EnumMultiMap> annotatedSubGraphs) {
        this(graphPartitioner, beginGraph, null, null, annotatedSubGraphs);
    }

    public Partitions(GraphPartitioner graphPartitioner, ElementGraph beginGraph, ElementGraph contractedGraph, List<Match> contractedMatches, Map<ElementGraph, EnumMultiMap> annotatedSubGraphs) {
        this.graphPartitioner = graphPartitioner;
        this.beginGraph = beginGraph;
        if (contractedGraph != null) {
            this.contractedGraph = contractedGraph;
        }
        if (contractedMatches != null) {
            this.contractedMatches = contractedMatches;
        }
        this.annotatedSubGraphs = annotatedSubGraphs;
    }

    public void setRulePartitioner(RulePartitioner rulePartitioner) {
        this.rulePartitioner = rulePartitioner;
    }

    @Override
    public String getRuleName() {
        if (this.rulePartitioner != null) {
            return this.rulePartitioner.getRuleName();
        }
        return "none";
    }

    @Override
    public ElementGraph getBeginGraph() {
        return this.beginGraph;
    }

    public ElementGraph getEndGraph() {
        return null;
    }

    public Map<ElementGraph, EnumMultiMap> getAnnotatedSubGraphs() {
        return this.annotatedSubGraphs;
    }

    public boolean hasSubGraphs() {
        return !this.annotatedSubGraphs.isEmpty();
    }

    public boolean hasContractedMatches() {
        return !this.contractedMatches.isEmpty();
    }

    public List<ElementGraph> getSubGraphs() {
        return new ArrayList<ElementGraph>(this.annotatedSubGraphs.keySet());
    }

    @Override
    public void writeDOTs(String path) {
        int count = 0;
        this.beginGraph.writeDOT(new File(path, this.makeFileName(count++, "element-graph")).toString());
        if (this.graphPartitioner instanceof ExpressionGraphPartitioner) {
            ExpressionGraph expressionGraph;
            ExpressionGraphPartitioner expressionGraphPartitioner = (ExpressionGraphPartitioner)this.graphPartitioner;
            ExpressionGraph contractionGraph = expressionGraphPartitioner.getContractionGraph();
            if (contractionGraph != null) {
                contractionGraph.writeDOT(new File(path, this.makeFileName(count++, "contraction-graph", contractionGraph)).toString());
            }
            if ((expressionGraph = expressionGraphPartitioner.getExpressionGraph()) != null) {
                expressionGraph.writeDOT(new File(path, this.makeFileName(count++, "expression-graph", expressionGraph)).toString());
            }
        }
        if (this.contractedGraph != null) {
            this.contractedGraph.writeDOT(new File(path, this.makeFileName(count++, "contracted-graph")).toString());
        }
        List<ElementGraph> subGraphs = this.getSubGraphs();
        for (int i = 0; i < subGraphs.size(); ++i) {
            ElementGraph subGraph = subGraphs.get(i);
            new ElementMultiGraph(subGraph, this.annotatedSubGraphs.get(subGraph)).writeDOT(new File(path, this.makeFileName(count, i, "partition-result-sub-graph")).toString());
            if (i >= this.contractedMatches.size()) continue;
            this.contractedMatches.get(i).getMatchedGraph().writeDOT(new File(path, this.makeFileName(count, i, "partition-contracted-graph")).toString());
        }
    }

    private String makeFileName(int ordinal, String name) {
        return String.format("%02d-%s.dot", ordinal, name);
    }

    private String makeFileName(int ordinal, String name, Object type) {
        return String.format("%02d-%s-%s.dot", ordinal, name, type.getClass().getSimpleName());
    }

    private String makeFileName(int order, int ordinal, String name) {
        return String.format("%02d-%04d-%s.dot", order, ordinal, name);
    }
}

