/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.finder;

import cascading.flow.FlowElement;
import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.expression.ElementExpression;
import cascading.flow.planner.iso.expression.Expression;
import cascading.flow.planner.iso.expression.ScopeExpression;
import cascading.flow.planner.iso.finder.FinderContext;
import cascading.flow.planner.iso.finder.IndexedElementGraph;
import cascading.flow.planner.iso.finder.IndexedMatchGraph;
import cascading.flow.planner.iso.finder.SearchOrder;
import cascading.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jgrapht.DirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class State {
    private static final Logger LOG = LoggerFactory.getLogger(State.class);
    public static final int NULL_NODE = -1;
    private FinderContext finderContext;
    private PlannerContext plannerContext;
    private IndexedMatchGraph matchGraph;
    private IndexedElementGraph elementGraph;
    int coreLen;
    int origCoreLen;
    int addedNode1;
    int t1bothLen;
    int t2bothLen;
    int t1inLen;
    int t1outLen;
    int t2inLen;
    int t2outLen;
    int[] core1;
    int[] core2;
    int[] in1;
    int[] in2;
    int[] out1;
    int[] out2;
    int[] order;
    private final int n1;
    private final int n2;

    State(FinderContext finderContext, PlannerContext plannerContext, SearchOrder searchOrder, DirectedGraph<ElementExpression, ScopeExpression> matchGraph, ElementGraph elementGraph) {
        this.finderContext = finderContext;
        this.plannerContext = plannerContext;
        this.matchGraph = new IndexedMatchGraph(matchGraph);
        this.elementGraph = new IndexedElementGraph(searchOrder, elementGraph);
        this.n1 = matchGraph.vertexSet().size();
        this.n2 = elementGraph.vertexSet().size();
        this.order = null;
        this.coreLen = 0;
        this.origCoreLen = 0;
        this.t1bothLen = 0;
        this.t1inLen = 0;
        this.t1outLen = 0;
        this.t2bothLen = 0;
        this.t2inLen = 0;
        this.t2outLen = 0;
        this.addedNode1 = -1;
        this.core1 = new int[this.n1];
        this.core2 = new int[this.n2];
        this.in1 = new int[this.n1];
        this.in2 = new int[this.n2];
        this.out1 = new int[this.n1];
        this.out2 = new int[this.n2];
        Arrays.fill(this.core1, -1);
        Arrays.fill(this.core2, -1);
    }

    protected State(State copy) {
        this.finderContext = copy.finderContext;
        this.plannerContext = copy.plannerContext;
        this.matchGraph = copy.matchGraph;
        this.elementGraph = copy.elementGraph;
        this.coreLen = copy.coreLen;
        this.origCoreLen = copy.coreLen;
        this.t1bothLen = copy.t1bothLen;
        this.t2bothLen = copy.t2bothLen;
        this.t1inLen = copy.t1inLen;
        this.t2inLen = copy.t2inLen;
        this.t1outLen = copy.t1outLen;
        this.t2outLen = copy.t2outLen;
        this.n1 = copy.n1;
        this.n2 = copy.n2;
        this.addedNode1 = -1;
        this.core1 = copy.core1;
        this.core2 = copy.core2;
        this.in1 = copy.in1;
        this.in2 = copy.in2;
        this.out1 = copy.out1;
        this.out2 = copy.out2;
        this.order = copy.order;
    }

    public Pair<Integer, Integer> nextPair(int prevN1, int prevN2) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("prev N1: {}, N2: {}", (Object)prevN1, (Object)prevN2);
        }
        if (prevN1 == -1) {
            prevN1 = 0;
        }
        prevN2 = prevN2 == -1 ? 0 : ++prevN2;
        if (this.t1bothLen > this.coreLen && this.t2bothLen > this.coreLen) {
            while (prevN1 < this.n1 && (this.core1[prevN1] != -1 || this.out1[prevN1] == 0 || this.in1[prevN1] == 0)) {
                ++prevN1;
                prevN2 = 0;
            }
        } else if (this.t1outLen > this.coreLen && this.t2outLen > this.coreLen) {
            while (prevN1 < this.n1 && (this.core1[prevN1] != -1 || this.out1[prevN1] == 0)) {
                ++prevN1;
                prevN2 = 0;
            }
        } else if (this.t1inLen > this.coreLen && this.t2inLen > this.coreLen) {
            while (prevN1 < this.n1 && (this.core1[prevN1] != -1 || this.in1[prevN1] == 0)) {
                ++prevN1;
                prevN2 = 0;
            }
        } else if (prevN1 == 0 && this.order != null) {
            int i;
            for (i = 0; i < this.n1 && this.core1[prevN1 = this.order[i]] != -1; ++i) {
            }
            if (i == this.n1) {
                prevN1 = this.n1;
            }
        } else {
            while (prevN1 < this.n1 && this.core1[prevN1] != -1) {
                ++prevN1;
                prevN2 = 0;
            }
        }
        if (this.t1bothLen > this.coreLen && this.t2bothLen > this.coreLen) {
            while (prevN2 < this.n2 && (this.core2[prevN2] != -1 || this.out2[prevN2] == 0 || this.in2[prevN2] == 0)) {
                ++prevN2;
            }
        } else if (this.t1outLen > this.coreLen && this.t2outLen > this.coreLen) {
            while (prevN2 < this.n2 && (this.core2[prevN2] != -1 || this.out2[prevN2] == 0)) {
                ++prevN2;
            }
        } else if (this.t1inLen > this.coreLen && this.t2inLen > this.coreLen) {
            while (prevN2 < this.n2 && (this.core2[prevN2] != -1 || this.in2[prevN2] == 0)) {
                ++prevN2;
            }
        } else {
            while (prevN2 < this.n2 && this.core2[prevN2] != -1) {
                ++prevN2;
            }
        }
        if (prevN1 < this.n1 && prevN2 < this.n2) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("next N1: {}, N2: {}", (Object)prevN1, (Object)prevN2);
            }
            return new Pair<Integer, Integer>(prevN1, prevN2);
        }
        return null;
    }

    protected boolean areCompatibleEdges(int v1, int v2, int v3, int v4) {
        List<ScopeExpression> matchers = this.matchGraph.getAllEdgesList(v1, v2);
        if (matchers.size() == 1 && matchers.get(0).acceptsAll()) {
            if (LOG.isDebugEnabled()) {
                this.debugCompatibleEdges(this.elementGraph.getAllEdgesList(v3, v4), v1, v2, matchers);
            }
            return true;
        }
        List<Scope> scopes = this.elementGraph.getAllEdgesList(v3, v4);
        Collection<Scope> results = State.areCompatibleEdges(this.plannerContext, this.elementGraph.getElementGraph(), matchers, scopes);
        if (LOG.isDebugEnabled() && results != null) {
            this.debugCompatibleEdges(results, v1, v2, matchers);
        }
        return results != null;
    }

    private void debugCompatibleEdges(Collection<Scope> results, int v1, int v2, List<ScopeExpression> matchers) {
        for (Scope result : results) {
            FlowElement lhs = (FlowElement)this.elementGraph.getDelegate().getEdgeSource((Object)result);
            int lhsIndex = this.elementGraph.getIndex(lhs);
            FlowElement rhs = (FlowElement)this.elementGraph.getDelegate().getEdgeTarget((Object)result);
            int rhsIndex = this.elementGraph.getIndex(rhs);
            LOG.debug("compatible edge: {}:{} -> {}:{}, having: {}", new Object[]{lhsIndex, lhs, rhsIndex, rhs, result.printSimple()});
        }
        for (ScopeExpression matcher : matchers) {
            LOG.debug(" - {} -> {} matcher: {}", new Object[]{v1, v2, matcher});
        }
    }

    public static Collection<Scope> areCompatibleEdges(PlannerContext plannerContext, ElementGraph elementGraph, List<ScopeExpression> matchers, List<Scope> scopes) {
        if (matchers.size() == 1) {
            ScopeExpression matcher = matchers.get(0);
            if (matcher.appliesToAllPaths()) {
                for (Scope scope : scopes) {
                    if (matcher.applies(plannerContext, elementGraph, scope)) continue;
                    return null;
                }
                return scopes;
            }
            if (matcher.appliesToAnyPath()) {
                for (Scope scope : scopes) {
                    if (!matcher.applies(plannerContext, elementGraph, scope)) continue;
                    return Collections.singleton(scope);
                }
                return null;
            }
            if (matcher.appliesToEachPath()) {
                scopes = new LinkedList<Scope>(scopes);
                ListIterator<Scope> iterator = scopes.listIterator();
                while (iterator.hasNext()) {
                    if (matcher.applies(plannerContext, elementGraph, iterator.next())) continue;
                    iterator.remove();
                }
                return scopes.isEmpty() ? null : scopes;
            }
        }
        if (matchers.size() != scopes.size()) {
            return null;
        }
        boolean[][] compat = new boolean[matchers.size()][scopes.size()];
        for (int i = 0; i < matchers.size(); ++i) {
            ScopeExpression matcher = matchers.get(i);
            for (int j = 0; j < scopes.size(); ++j) {
                Scope scope = scopes.get(j);
                compat[i][j] = matcher.applies(plannerContext, elementGraph, scope);
            }
        }
        ArrayList<Integer> range = new ArrayList<Integer>();
        for (int i = 0; i < compat.length; ++i) {
            range.add(i);
        }
        PermutationIterator iterator = new PermutationIterator(range);
        boolean[][] transformed = new boolean[matchers.size()][];
        while (iterator.hasNext()) {
            List permutation = (List)iterator.next();
            for (int i = 0; i < permutation.size(); ++i) {
                transformed[i] = compat[(Integer)permutation.get(i)];
            }
            boolean result = transformed[0][0];
            for (int i = 1; i < scopes.size(); ++i) {
                result &= transformed[i][i];
            }
            if (!result) continue;
            return scopes;
        }
        return null;
    }

    private boolean areCompatibleNodes(int node1, int node2) {
        Expression expression = (Expression)this.matchGraph.getVertex(node1);
        FlowElement flowElement = (FlowElement)this.elementGraph.getVertex(node2);
        boolean result = ((ElementExpression)expression).getCapture() == ElementCapture.Primary && !this.finderContext.getRequiredElements().isEmpty() ? this.finderContext.isRequired(flowElement) : (this.finderContext.isExcluded(flowElement) || this.finderContext.isIgnored(flowElement) ? false : expression.applies(this.plannerContext, this.elementGraph.getElementGraph(), flowElement));
        if (LOG.isDebugEnabled() && result) {
            LOG.debug("compatible nodes: {}:{} matched {}:{}", new Object[]{node1, expression, node2, flowElement});
        }
        return result;
    }

    public boolean isFeasiblePair(int node1, int node2) {
        boolean isFeasible;
        int other1;
        int other2;
        assert (node1 < this.n1);
        assert (node2 < this.n2);
        assert (this.core1[node1] == -1);
        assert (this.core2[node2] == -1);
        if (!this.areCompatibleNodes(node1, node2)) {
            return false;
        }
        int termout1 = 0;
        int termout2 = 0;
        int termin1 = 0;
        int termin2 = 0;
        int new1 = 0;
        int new2 = 0;
        for (int other12 : this.matchGraph.getSuccessors(node1)) {
            if (this.core1[other12] != -1) {
                other2 = this.core1[other12];
                if (this.elementGraph.containsEdge(node2, other2) && this.areCompatibleEdges(node1, other12, node2, other2)) continue;
                return false;
            }
            if (this.in1[other12] != 0) {
                ++termin1;
            }
            if (this.out1[other12] != 0) {
                ++termout1;
            }
            if (this.in1[other12] != 0 || this.out1[other12] != 0) continue;
            ++new1;
        }
        for (int other12 : this.matchGraph.getPredecessors(node1)) {
            if (this.core1[other12] != -1) {
                other2 = this.core1[other12];
                if (this.elementGraph.containsEdge(other2, node2) && this.areCompatibleEdges(other12, node1, other2, node2)) continue;
                return false;
            }
            if (this.in1[other12] != 0) {
                ++termin1;
            }
            if (this.out1[other12] != 0) {
                ++termout1;
            }
            if (this.in1[other12] != 0 || this.out1[other12] != 0) continue;
            ++new1;
        }
        for (int other22 : this.elementGraph.getSuccessors(node2)) {
            if (this.core2[other22] != -1) {
                other1 = this.core2[other22];
                if (this.matchGraph.containsEdge(node1, other1)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("no matcher edge between nodes: {}:{} -> {}:{}", new Object[]{node1, this.matchGraph.getVertex(node1), other1, this.matchGraph.getVertex(other1)});
                }
                return false;
            }
            if (this.in2[other22] != 0) {
                ++termin2;
            }
            if (this.out2[other22] != 0) {
                ++termout2;
            }
            if (this.in2[other22] != 0 || this.out2[other22] != 0) continue;
            ++new2;
        }
        for (int other22 : this.elementGraph.getPredecessors(node2)) {
            if (this.core2[other22] != -1) {
                other1 = this.core2[other22];
                if (this.matchGraph.containsEdge(other1, node1)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("no matcher edge between nodes: {}:{} -> {}:{}", new Object[]{other1, this.matchGraph.getVertex(other1), node1, this.matchGraph.getVertex(node1)});
                }
                return false;
            }
            if (this.in2[other22] != 0) {
                ++termin2;
            }
            if (this.out2[other22] != 0) {
                ++termout2;
            }
            if (this.in2[other22] != 0 || this.out2[other22] != 0) continue;
            ++new2;
        }
        boolean bl = isFeasible = termin1 <= termin2 && termout1 <= termout2 && new1 <= new2;
        if (LOG.isTraceEnabled()) {
            LOG.trace("feasible: {} = termin1({}) <= termin2({}) && termout1({}) <= termout2({}) && new1({}) <= new2({})", new Object[]{isFeasible, termin1, termin2, termout1, termout2, new1, new2});
        }
        return isFeasible;
    }

    public void addPair(int node1, int node2) {
        assert (node1 < this.n1);
        assert (node2 < this.n2);
        assert (this.coreLen < this.n1);
        assert (this.coreLen < this.n2);
        ++this.coreLen;
        this.addedNode1 = node1;
        if (this.in1[node1] == 0) {
            this.in1[node1] = this.coreLen;
            ++this.t1inLen;
            if (this.out1[node1] != 0) {
                ++this.t1bothLen;
            }
        }
        if (this.out1[node1] == 0) {
            this.out1[node1] = this.coreLen;
            ++this.t1outLen;
            if (this.in1[node1] != 0) {
                ++this.t1bothLen;
            }
        }
        if (this.in2[node2] == 0) {
            this.in2[node2] = this.coreLen;
            ++this.t2inLen;
            if (this.out2[node2] != 0) {
                ++this.t2bothLen;
            }
        }
        if (this.out2[node2] == 0) {
            this.out2[node2] = this.coreLen;
            ++this.t2outLen;
            if (this.in2[node2] != 0) {
                ++this.t2bothLen;
            }
        }
        this.core1[node1] = node2;
        this.core2[node2] = node1;
        for (int other : this.matchGraph.getPredecessors(node1)) {
            if (this.in1[other] != 0) continue;
            this.in1[other] = this.coreLen;
            ++this.t1inLen;
            if (this.out1[other] == 0) continue;
            ++this.t1bothLen;
        }
        for (int other : this.matchGraph.getSuccessors(node1)) {
            if (this.out1[other] != 0) continue;
            this.out1[other] = this.coreLen;
            ++this.t1outLen;
            if (this.in1[other] == 0) continue;
            ++this.t1bothLen;
        }
        for (int other : this.elementGraph.getPredecessors(node2)) {
            if (this.in2[other] != 0) continue;
            this.in2[other] = this.coreLen;
            ++this.t2inLen;
            if (this.out2[other] == 0) continue;
            ++this.t2bothLen;
        }
        for (int other : this.elementGraph.getSuccessors(node2)) {
            if (this.out2[other] != 0) continue;
            this.out2[other] = this.coreLen;
            ++this.t2outLen;
            if (this.in2[other] == 0) continue;
            ++this.t2bothLen;
        }
    }

    public boolean isGoal() {
        return this.coreLen == this.n1;
    }

    public boolean isDead() {
        return this.n1 > this.n2 || this.t1bothLen > this.t2bothLen || this.t1outLen > this.t2outLen || this.t1inLen > this.t2inLen;
    }

    public Map<Integer, Integer> getVertexMapping() {
        HashMap<Integer, Integer> vertexMapping = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.n1; ++i) {
            if (this.core1[i] == -1) continue;
            vertexMapping.put(i, this.core1[i]);
        }
        return vertexMapping;
    }

    public State copy() {
        return new State(this);
    }

    public void backTrack() {
        assert (this.coreLen - this.origCoreLen <= 1);
        assert (this.addedNode1 != -1);
        if (this.origCoreLen >= this.coreLen) {
            return;
        }
        if (this.in1[this.addedNode1] == this.coreLen) {
            this.in1[this.addedNode1] = 0;
        }
        for (int other : this.matchGraph.getPredecessors(this.addedNode1)) {
            if (this.in1[other] != this.coreLen) continue;
            this.in1[other] = 0;
        }
        if (this.out1[this.addedNode1] == this.coreLen) {
            this.out1[this.addedNode1] = 0;
        }
        for (int other : this.matchGraph.getSuccessors(this.addedNode1)) {
            if (this.out1[other] != this.coreLen) continue;
            this.out1[other] = 0;
        }
        int node2 = this.core1[this.addedNode1];
        if (this.in2[node2] == this.coreLen) {
            this.in2[node2] = 0;
        }
        for (int other : this.elementGraph.getPredecessors(node2)) {
            if (this.in2[other] != this.coreLen) continue;
            this.in2[other] = 0;
        }
        if (this.out2[node2] == this.coreLen) {
            this.out2[node2] = 0;
        }
        for (int other : this.elementGraph.getSuccessors(node2)) {
            if (this.out2[other] != this.coreLen) continue;
            this.out2[other] = 0;
        }
        this.core1[this.addedNode1] = -1;
        this.core2[node2] = -1;
        this.coreLen = this.origCoreLen;
        this.addedNode1 = -1;
    }

    public ElementExpression getMatcherNode(int vertex) {
        return (ElementExpression)this.matchGraph.getVertex(vertex);
    }

    public FlowElement getElementNode(int vertex) {
        return (FlowElement)this.elementGraph.getVertex(vertex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("State{");
        sb.append("coreLen=").append(this.coreLen);
        sb.append('}');
        return sb.toString();
    }

    private static abstract class AbstractIterator<T>
    implements Iterator<T> {
        private StateEnum state = StateEnum.NOT_READY;
        private T next;

        protected AbstractIterator() {
        }

        protected abstract T computeNext();

        protected final T endOfData() {
            this.state = StateEnum.DONE;
            return null;
        }

        @Override
        public final boolean hasNext() {
            if (this.state == StateEnum.FAILED) {
                throw new IllegalStateException();
            }
            switch (this.state) {
                case DONE: {
                    return false;
                }
                case READY: {
                    return true;
                }
            }
            return this.tryToComputeNext();
        }

        private boolean tryToComputeNext() {
            this.state = StateEnum.FAILED;
            this.next = this.computeNext();
            if (this.state != StateEnum.DONE) {
                this.state = StateEnum.READY;
                return true;
            }
            return false;
        }

        @Override
        public final T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.state = StateEnum.NOT_READY;
            return this.next;
        }

        private static enum StateEnum {
            READY,
            NOT_READY,
            DONE,
            FAILED;

        }
    }

    private static class PermutationIterator<E>
    extends AbstractIterator<List<E>> {
        final List<E> list;
        final int[] c;
        final int[] o;
        int j;

        PermutationIterator(List<E> list) {
            this.list = new ArrayList<E>(list);
            int n = list.size();
            this.c = new int[n];
            this.o = new int[n];
            for (int i = 0; i < n; ++i) {
                this.c[i] = 0;
                this.o[i] = 1;
            }
            this.j = Integer.MAX_VALUE;
        }

        @Override
        protected List<E> computeNext() {
            if (this.j <= 0) {
                return (List)this.endOfData();
            }
            List<E> next = Collections.unmodifiableList(new ArrayList<E>(this.list));
            this.calculateNextPermutation();
            return next;
        }

        void calculateNextPermutation() {
            block4: {
                int q;
                this.j = this.list.size() - 1;
                int s = 0;
                if (this.j == -1) {
                    return;
                }
                while (true) {
                    if ((q = this.c[this.j] + this.o[this.j]) < 0) {
                        this.switchDirection();
                        continue;
                    }
                    if (q != this.j + 1) break;
                    if (this.j != 0) {
                        ++s;
                        this.switchDirection();
                        continue;
                    }
                    break block4;
                    break;
                }
                Collections.swap(this.list, this.j - this.c[this.j] + s, this.j - q + s);
                this.c[this.j] = q;
            }
        }

        void switchDirection() {
            this.o[this.j] = -this.o[this.j];
            --this.j;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

