/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.finder;

import cascading.flow.planner.graph.Extent;
import java.util.Iterator;
import org.jgrapht.Graph;
import org.jgrapht.graph.EdgeReversedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.jgrapht.traverse.DepthFirstIterator;
import org.jgrapht.traverse.TopologicalOrderIterator;

public enum SearchOrder {
    Depth,
    Breadth,
    Topological,
    ReverseDepth(true),
    ReverseBreadth(true),
    ReverseTopological(true);

    final boolean isReversed;

    private SearchOrder() {
        this.isReversed = false;
    }

    private SearchOrder(boolean isReversed) {
        this.isReversed = isReversed;
    }

    public boolean isReversed() {
        return this.isReversed;
    }

    public static <Node, G extends Graph> Iterator<Node> getNodeIterator(SearchOrder searchOrder, G graph) {
        if (searchOrder == null) {
            return new TopologicalOrderIterator(graph);
        }
        Extent node = null;
        if (graph.containsVertex((Object)Extent.head)) {
            node = !searchOrder.isReversed() ? Extent.head : Extent.tail;
        }
        switch (searchOrder) {
            case Depth: {
                return new DepthFirstIterator(graph, (Object)node);
            }
            case Breadth: {
                return new BreadthFirstIterator(graph, (Object)node);
            }
            case Topological: {
                return new TopologicalOrderIterator(graph);
            }
            case ReverseDepth: {
                return new DepthFirstIterator((Graph)new EdgeReversedGraph(graph), (Object)node);
            }
            case ReverseBreadth: {
                return new BreadthFirstIterator((Graph)new EdgeReversedGraph(graph), (Object)node);
            }
            case ReverseTopological: {
                return new TopologicalOrderIterator((Graph)new EdgeReversedGraph(graph));
            }
        }
        throw new IllegalStateException("unknown order: " + (Object)((Object)searchOrder));
    }
}

